/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.handler.graphql.ApolloWSMessageType;

/**
 * A message recevied over Apollo's <code>subscriptions-transport-ws</code> transport.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ApolloWSMessage original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.graphql.ApolloWSMessage.class)
public class ApolloWSMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApolloWSMessage that = (ApolloWSMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ApolloWSMessage> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ApolloWSMessage((io.vertx.ext.web.handler.graphql.ApolloWSMessage) obj),
    ApolloWSMessage::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ApolloWSMessage delegate;
  
  public ApolloWSMessage(io.vertx.ext.web.handler.graphql.ApolloWSMessage delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.graphql.ApolloWSMessage getDelegate() {
    return delegate;
  }

  /**
   * @return the websocket that received the message
   */
  public io.vertx.reactivex.core.http.ServerWebSocket serverWebSocket() { 
    io.vertx.reactivex.core.http.ServerWebSocket ret = io.vertx.reactivex.core.http.ServerWebSocket.newInstance(delegate.serverWebSocket());
    return ret;
  }

  /**
   * @return the message type
   */
  public ApolloWSMessageType type() { 
    ApolloWSMessageType ret = delegate.type();
    return ret;
  }

  /**
   * @return the message content
   */
  public JsonObject content() { 
    JsonObject ret = delegate.content();
    return ret;
  }


  public static  ApolloWSMessage newInstance(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
    return arg != null ? new ApolloWSMessage(arg) : null;
  }
}
