/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;
import java.util.function.Function;
import io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions;

/**
 * A {@link io.vertx.reactivex.ext.web.Route} handler for GraphiQL resources.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.GraphiQLHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.graphql.GraphiQLHandler.class)
public class GraphiQLHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphiQLHandler that = (GraphiQLHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<GraphiQLHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new GraphiQLHandler((io.vertx.ext.web.handler.graphql.GraphiQLHandler) obj),
    GraphiQLHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.GraphiQLHandler delegate;
  
  public GraphiQLHandler(io.vertx.ext.web.handler.graphql.GraphiQLHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.graphql.GraphiQLHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with default {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler create() { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler.newInstance(io.vertx.ext.web.handler.graphql.GraphiQLHandler.create());
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param options options for configuring the {@link io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler create(GraphiQLHandlerOptions options) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler.newInstance(io.vertx.ext.web.handler.graphql.GraphiQLHandler.create(options));
    return ret;
  }

  /**
   * Customize the HTTP headers to add to GraphQL requests sent by the GraphiQL user interface.
   * The result will be applied on top of the fixed set of headers specified in {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * <p>
   * This can be useful if, for example, the server is protected by authentication.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler graphiQLRequestHeaders(Function<io.vertx.reactivex.ext.web.RoutingContext, io.vertx.reactivex.core.MultiMap> factory) { 
    delegate.graphiQLRequestHeaders(new java.util.function.Function<io.vertx.ext.web.RoutingContext,io.vertx.core.MultiMap>() {
      public io.vertx.core.MultiMap apply(io.vertx.ext.web.RoutingContext arg) {
        io.vertx.reactivex.core.MultiMap ret = factory.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance(arg));
        return ret.getDelegate();
      }
    });
    return this;
  }


  public static  GraphiQLHandler newInstance(io.vertx.ext.web.handler.graphql.GraphiQLHandler arg) {
    return arg != null ? new GraphiQLHandler(arg) : null;
  }
}
