/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.templ.mvel;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * A template engine that uses the Handlebars library.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.mvel.MVELTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.templ.mvel.MVELTemplateEngine.class)
public class MVELTemplateEngine extends io.vertx.reactivex.ext.web.common.template.TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MVELTemplateEngine that = (MVELTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MVELTemplateEngine> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MVELTemplateEngine((io.vertx.ext.web.templ.mvel.MVELTemplateEngine) obj),
    MVELTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.mvel.MVELTemplateEngine delegate;
  
  public MVELTemplateEngine(io.vertx.ext.web.templ.mvel.MVELTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.web.templ.mvel.MVELTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine ret = io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine.newInstance(io.vertx.ext.web.templ.mvel.MVELTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param extension the extension
   * @return a reference to this for fluency
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine setExtension(String extension) { 
    delegate.setExtension(extension);
    return this;
  }

  /**
   * Set the max cache size for the engine
   * @param maxCacheSize the maxCacheSize
   * @return a reference to this for fluency
   */
  public io.vertx.reactivex.ext.web.templ.mvel.MVELTemplateEngine setMaxCacheSize(int maxCacheSize) { 
    delegate.setMaxCacheSize(maxCacheSize);
    return this;
  }

  /**
   * Default max number of templates to cache
   */
  public static final int DEFAULT_MAX_CACHE_SIZE = io.vertx.ext.web.templ.mvel.MVELTemplateEngine.DEFAULT_MAX_CACHE_SIZE;
  /**
   * Default template extension
   */
  public static final String DEFAULT_TEMPLATE_EXTENSION = io.vertx.ext.web.templ.mvel.MVELTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;

  public static  MVELTemplateEngine newInstance(io.vertx.ext.web.templ.mvel.MVELTemplateEngine arg) {
    return arg != null ? new MVELTemplateEngine(arg) : null;
  }
}
