/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.kafka.admin;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.ConsumerGroupListing;
import java.util.Map;
import java.util.Set;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Vert.x Kafka Admin client implementation
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.admin.KafkaAdminClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaAdminClient that = (KafkaAdminClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<KafkaAdminClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient) obj),
    KafkaAdminClient::getDelegate
  );

  private final io.vertx.kafka.admin.KafkaAdminClient delegate;
  
  public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
    return delegate;
  }

  /**
   * Create a new KafkaAdminClient instance
   * @param vertx Vert.x instance to use
   * @param config Kafka admin client configuration
   * @return an instance of the KafkaAdminClient
   */
  public static io.vertx.reactivex.kafka.admin.KafkaAdminClient create(io.vertx.reactivex.core.Vertx vertx, Map<String, String> config) { 
    io.vertx.reactivex.kafka.admin.KafkaAdminClient ret = io.vertx.reactivex.kafka.admin.KafkaAdminClient.newInstance(io.vertx.kafka.admin.KafkaAdminClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * List the topics available in the cluster with the default options.
   * @param completionHandler handler called on operation completed with the topics set
   */
  public void listTopics(Handler<AsyncResult<Set<String>>> completionHandler) { 
    delegate.listTopics(completionHandler);
  }

  /**
   * List the topics available in the cluster with the default options.
   * @return 
   */
  public Single<Set<String>> rxListTopics() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listTopics(handler);
    });
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @param completionHandler handler called on operation completed
   */
  public void createTopics(List<NewTopic> topics, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.createTopics(topics, completionHandler);
  }

  /**
   * Creates a batch of new Kafka topics
   * @param topics topics to create
   * @return 
   */
  public Completable rxCreateTopics(List<NewTopic> topics) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createTopics(topics, handler);
    });
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @param completionHandler handler called on operation completed
   */
  public void deleteTopics(List<String> topicNames, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.deleteTopics(topicNames, completionHandler);
  }

  /**
   * Deletes a batch of Kafka topics
   * @param topicNames the names of the topics to delete
   * @return 
   */
  public Completable rxDeleteTopics(List<String> topicNames) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deleteTopics(topicNames, handler);
    });
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * @param completionHandler handler called on operation completed with the consumer groups ids
   */
  public void listConsumerGroups(Handler<AsyncResult<List<ConsumerGroupListing>>> completionHandler) { 
    delegate.listConsumerGroups(completionHandler);
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * @return 
   */
  public Single<List<ConsumerGroupListing>> rxListConsumerGroups() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listConsumerGroups(handler);
    });
  }


  public static  KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
    return arg != null ? new KafkaAdminClient(arg) : null;
  }
}
