/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import java.util.List;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttWill;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents an MQTT endpoint for point-to-point communication with the remote MQTT client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttEndpoint original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mqtt.MqttEndpoint.class)
public class MqttEndpoint {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttEndpoint that = (MqttEndpoint) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MqttEndpoint> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MqttEndpoint((io.vertx.mqtt.MqttEndpoint) obj),
    MqttEndpoint::getDelegate
  );

  private final io.vertx.mqtt.MqttEndpoint delegate;
  
  public MqttEndpoint(io.vertx.mqtt.MqttEndpoint delegate) {
    this.delegate = delegate;
  }

  public io.vertx.mqtt.MqttEndpoint getDelegate() {
    return delegate;
  }

  /**
   * Close the endpoint, so the connection with remote MQTT client
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the remote address for this socket
   */
  public io.vertx.reactivex.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this socket
   */
  public io.vertx.reactivex.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.reactivex.mqtt.MqttEndpoint} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return the client identifier as provided by the remote MQTT client
   */
  public String clientIdentifier() { 
    if (cached_2 != null) {
      return cached_2;
    }
    String ret = delegate.clientIdentifier();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the Authentication information as provided by the remote MQTT client
   */
  public MqttAuth auth() { 
    if (cached_3 != null) {
      return cached_3;
    }
    MqttAuth ret = delegate.auth();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the Will information as provided by the remote MQTT client
   */
  public MqttWill will() { 
    if (cached_4 != null) {
      return cached_4;
    }
    MqttWill ret = delegate.will();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the protocol version required by the remote MQTT client
   */
  public int protocolVersion() { 
    if (cached_5 != null) {
      return cached_5;
    }
    int ret = delegate.protocolVersion();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return the protocol name provided by the remote MQTT client
   */
  public String protocolName() { 
    if (cached_6 != null) {
      return cached_6;
    }
    String ret = delegate.protocolName();
    cached_6 = ret;
    return ret;
  }

  /**
   * @return true when clean session is requested by the remote MQTT client
   */
  public boolean isCleanSession() { 
    if (cached_7 != null) {
      return cached_7;
    }
    boolean ret = delegate.isCleanSession();
    cached_7 = ret;
    return ret;
  }

  /**
   * @return the keep alive timeout (in seconds) specified by the remote MQTT client
   */
  public int keepAliveTimeSeconds() { 
    if (cached_8 != null) {
      return cached_8;
    }
    int ret = delegate.keepAliveTimeSeconds();
    cached_8 = ret;
    return ret;
  }

  /**
   * @return the message identifier used for last published message
   */
  public int lastMessageId() { 
    if (cached_9 != null) {
      return cached_9;
    }
    int ret = delegate.lastMessageId();
    cached_9 = ret;
    return ret;
  }

  /**
   * Enable/disable subscription/unsubscription requests auto acknowledge
   * @param isSubscriptionAutoAck auto acknowledge status
   */
  public void subscriptionAutoAck(boolean isSubscriptionAutoAck) { 
    delegate.subscriptionAutoAck(isSubscriptionAutoAck);
  }

  /**
   * @return true when auto acknowledge status for subscription/unsubscription requests
   */
  public boolean isSubscriptionAutoAck() { 
    boolean ret = delegate.isSubscriptionAutoAck();
    return ret;
  }

  /**
   * Enable/disable publishing (in/out) auto acknowledge
   * @param isPublishAutoAck auto acknowledge status
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishAutoAck(boolean isPublishAutoAck) { 
    delegate.publishAutoAck(isPublishAutoAck);
    return this;
  }

  /**
   * @return auto acknowledge status for publishing (in/out)
   */
  public boolean isPublishAutoAck() { 
    boolean ret = delegate.isPublishAutoAck();
    return ret;
  }

  /**
   * Enable/disable auto keep alive (sending ping response)
   * @param isAutoKeepAlive auto keep alive
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint autoKeepAlive(boolean isAutoKeepAlive) { 
    delegate.autoKeepAlive(isAutoKeepAlive);
    return this;
  }

  /**
   * @return the auto keep alive status (sending ping response)
   */
  public boolean isAutoKeepAlive() { 
    boolean ret = delegate.isAutoKeepAlive();
    return ret;
  }

  /**
   * @return if the connection between remote client and local endpoint is established/open
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Set client identifier if not provided by the remote MQTT client (zero-bytes)
   * @param clientIdentifier the client identifier
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint setClientIdentifier(String clientIdentifier) { 
    delegate.setClientIdentifier(clientIdentifier);
    return this;
  }

  /**
   * Set a disconnect handler on the MQTT endpoint. This handler is called when a DISCONNECT
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint disconnectHandler(Handler<Void> handler) { 
    delegate.disconnectHandler(handler);
    return this;
  }

  /**
   * Set a subscribe handler on the MQTT endpoint. This handler is called when a SUBSCRIBE
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint subscribeHandler(Handler<io.vertx.reactivex.mqtt.messages.MqttSubscribeMessage> handler) { 
    delegate.subscribeHandler(new Handler<io.vertx.mqtt.messages.MqttSubscribeMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttSubscribeMessage event) {
        handler.handle(io.vertx.reactivex.mqtt.messages.MqttSubscribeMessage.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a unsubscribe handler on the MQTT endpoint. This handler is called when a UNSUBSCRIBE
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint unsubscribeHandler(Handler<io.vertx.reactivex.mqtt.messages.MqttUnsubscribeMessage> handler) { 
    delegate.unsubscribeHandler(new Handler<io.vertx.mqtt.messages.MqttUnsubscribeMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttUnsubscribeMessage event) {
        handler.handle(io.vertx.reactivex.mqtt.messages.MqttUnsubscribeMessage.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set the publish handler on the MQTT endpoint. This handler is called when a PUBLISH
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishHandler(Handler<io.vertx.reactivex.mqtt.messages.MqttPublishMessage> handler) { 
    delegate.publishHandler(new Handler<io.vertx.mqtt.messages.MqttPublishMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
        handler.handle(io.vertx.reactivex.mqtt.messages.MqttPublishMessage.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set the puback handler on the MQTT endpoint. This handler is called when a PUBACK
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishAcknowledgeHandler(Handler<Integer> handler) { 
    delegate.publishAcknowledgeHandler(handler);
    return this;
  }

  /**
   * Set the pubrec handler on the MQTT endpoint. This handler is called when a PUBREC
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishReceivedHandler(Handler<Integer> handler) { 
    delegate.publishReceivedHandler(handler);
    return this;
  }

  /**
   * Set the pubrel handler on the MQTT endpoint. This handler is called when a PUBREL
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishReleaseHandler(Handler<Integer> handler) { 
    delegate.publishReleaseHandler(handler);
    return this;
  }

  /**
   * Set the pubcomp handler on the MQTT endpoint. This handler is called when a PUBCOMP
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishCompletionHandler(Handler<Integer> handler) { 
    delegate.publishCompletionHandler(handler);
    return this;
  }

  /**
   * Set the pingreq handler on the MQTT endpoint. This handler is called when a PINGREQ
   * message is received by the remote MQTT client. In any case the endpoint sends the
   * PINGRESP internally after executing this handler.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint pingHandler(Handler<Void> handler) { 
    delegate.pingHandler(handler);
    return this;
  }

  /**
   * Set a close handler. This will be called when the MQTT endpoint is closed
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set an exception handler. This will be called when an error at protocol level happens
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.mqtt.MqttEndpoint#accept} with no session is present.
   * @return 
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint accept() { 
    delegate.accept();
    return this;
  }

  /**
   * Sends the CONNACK message to the remote MQTT client with "connection accepted"
   * return code. See {@link io.vertx.reactivex.mqtt.MqttEndpoint#reject} for refusing connection
   * @param sessionPresent if a previous session is present
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint accept(boolean sessionPresent) { 
    delegate.accept(sessionPresent);
    return this;
  }

  /**
   * Sends the CONNACK message to the remote MQTT client rejecting the connection
   * request with specified return code. See {@link io.vertx.reactivex.mqtt.MqttEndpoint#accept} for accepting connection
   * @param returnCode the connect return code
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint reject(MqttConnectReturnCode returnCode) { 
    delegate.reject(returnCode);
    return this;
  }

  /**
   * Sends the SUBACK message to the remote MQTT client
   * @param subscribeMessageId identifier of the SUBSCRIBE message to acknowledge
   * @param grantedQoSLevels granted QoS levels for the requested topics
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint subscribeAcknowledge(int subscribeMessageId, List<MqttQoS> grantedQoSLevels) { 
    delegate.subscribeAcknowledge(subscribeMessageId, grantedQoSLevels);
    return this;
  }

  /**
   * Sends the UNSUBACK message to the remote MQTT client
   * @param unsubscribeMessageId identifier of the UNSUBSCRIBE message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId) { 
    delegate.unsubscribeAcknowledge(unsubscribeMessageId);
    return this;
  }

  /**
   * Sends the PUBACK message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishAcknowledge(int publishMessageId) { 
    delegate.publishAcknowledge(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBREC message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishReceived(int publishMessageId) { 
    delegate.publishReceived(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBREL message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishRelease(int publishMessageId) { 
    delegate.publishRelease(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBCOMP message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publishComplete(int publishMessageId) { 
    delegate.publishComplete(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT client
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel quality of service level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publish(String topic, io.vertx.reactivex.core.buffer.Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param publishSentHandler handler called after PUBLISH packet sent with a packetId
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publish(String topic, io.vertx.reactivex.core.buffer.Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) { 
    delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public Single<Integer> rxPublish(String topic, io.vertx.reactivex.core.buffer.Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      publish(topic, payload, qosLevel, isDup, isRetain, handler);
    });
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @param publishSentHandler handler called after PUBLISH packet sent with a packetId
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint publish(String topic, io.vertx.reactivex.core.buffer.Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, Handler<AsyncResult<Integer>> publishSentHandler) { 
    delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, messageId, publishSentHandler);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @return current MQTT client instance
   */
  public Single<Integer> rxPublish(String topic, io.vertx.reactivex.core.buffer.Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      publish(topic, payload, qosLevel, isDup, isRetain, messageId, handler);
    });
  }

  /**
   * Sends the PINGRESP message to the remote MQTT client
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mqtt.MqttEndpoint pong() { 
    delegate.pong();
    return this;
  }

  private io.vertx.reactivex.core.net.SocketAddress cached_0;
  private io.vertx.reactivex.core.net.SocketAddress cached_1;
  private String cached_2;
  private MqttAuth cached_3;
  private MqttWill cached_4;
  private java.lang.Integer cached_5;
  private String cached_6;
  private java.lang.Boolean cached_7;
  private java.lang.Integer cached_8;
  private java.lang.Integer cached_9;

  public static  MqttEndpoint newInstance(io.vertx.mqtt.MqttEndpoint arg) {
    return arg != null ? new MqttEndpoint(arg) : null;
  }
}
