/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt.messages;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * Represent the interface for each MQTT message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttMessage original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mqtt.messages.MqttMessage.class)
public interface MqttMessage {

  io.vertx.mqtt.messages.MqttMessage getDelegate();

  /**
   * @return Message identifier
   */
  public int messageId();


  public static  MqttMessage newInstance(io.vertx.mqtt.messages.MqttMessage arg) {
    return arg != null ? new MqttMessageImpl(arg) : null;
  }
}

class MqttMessageImpl implements MqttMessage {
  private final io.vertx.mqtt.messages.MqttMessage delegate;
  
  public MqttMessageImpl(io.vertx.mqtt.messages.MqttMessage delegate) {
    this.delegate = delegate;
  }

  public io.vertx.mqtt.messages.MqttMessage getDelegate() {
    return delegate;
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
}
