/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt.messages;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.netty.handler.codec.mqtt.MqttQoS;

/**
 * Represents an MQTT PUBLISH message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttPublishMessage original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mqtt.messages.MqttPublishMessage.class)
public class MqttPublishMessage implements io.vertx.reactivex.mqtt.messages.MqttMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttPublishMessage that = (MqttPublishMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MqttPublishMessage> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MqttPublishMessage((io.vertx.mqtt.messages.MqttPublishMessage) obj),
    MqttPublishMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttPublishMessage delegate;
  
  public MqttPublishMessage(io.vertx.mqtt.messages.MqttPublishMessage delegate) {
    this.delegate = delegate;
  }

  public io.vertx.mqtt.messages.MqttPublishMessage getDelegate() {
    return delegate;
  }

  /**
   * @return Message identifier
   */
  public int messageId() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.messageId();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return Quality of service level
   */
  public MqttQoS qosLevel() { 
    if (cached_1 != null) {
      return cached_1;
    }
    MqttQoS ret = delegate.qosLevel();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return If the message is a duplicate
   */
  public boolean isDup() { 
    if (cached_2 != null) {
      return cached_2;
    }
    boolean ret = delegate.isDup();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return If the message needs to be retained
   */
  public boolean isRetain() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.isRetain();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return Topic on which the message was published
   */
  public String topicName() { 
    if (cached_4 != null) {
      return cached_4;
    }
    String ret = delegate.topicName();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return Payload message
   */
  public io.vertx.reactivex.core.buffer.Buffer payload() { 
    if (cached_5 != null) {
      return cached_5;
    }
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance(delegate.payload());
    cached_5 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private MqttQoS cached_1;
  private java.lang.Boolean cached_2;
  private java.lang.Boolean cached_3;
  private String cached_4;
  private io.vertx.reactivex.core.buffer.Buffer cached_5;

  public static  MqttPublishMessage newInstance(io.vertx.mqtt.messages.MqttPublishMessage arg) {
    return arg != null ? new MqttPublishMessage(arg) : null;
  }
}
