/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mysqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * An interface to define MySQL specific constants or behaviors.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mysqlclient.MySQLClient.class)
public class MySQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLClient that = (MySQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MySQLClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MySQLClient((io.vertx.mysqlclient.MySQLClient) obj),
    MySQLClient::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLClient delegate;
  
  public MySQLClient(io.vertx.mysqlclient.MySQLClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.mysqlclient.MySQLClient getDelegate() {
    return delegate;
  }

  /**
   * SqlResult Property for last_insert_id
   */
  public static final io.vertx.reactivex.sqlclient.PropertyKind<Integer> LAST_INSERTED_ID = io.vertx.reactivex.sqlclient.PropertyKind.newInstance(io.vertx.mysqlclient.MySQLClient.LAST_INSERTED_ID, io.vertx.lang.rx.TypeArg.unknown());

  public static  MySQLClient newInstance(io.vertx.mysqlclient.MySQLClient arg) {
    return arg != null ? new MySQLClient(arg) : null;
  }
}
