/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.pgclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.pgclient.PgNotification;
import java.util.List;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A connection to Postgres.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgConnection original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.pgclient.PgConnection.class)
public class PgConnection extends io.vertx.reactivex.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgConnection that = (PgConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<PgConnection> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new PgConnection((io.vertx.pgclient.PgConnection) obj),
    PgConnection::getDelegate
  );

  private final io.vertx.pgclient.PgConnection delegate;
  
  public PgConnection(io.vertx.pgclient.PgConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.pgclient.PgConnection getDelegate() {
    return delegate;
  }

  /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * @param vertx the vertx instance
   * @param options the connect options
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, PgConnectOptions options, Handler<AsyncResult<io.vertx.reactivex.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), options, new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>() {
      public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.pgclient.PgConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Connects to the database and returns the connection if that succeeds.
   * <p/>
   * The connection interracts directly with the database is not a proxy, so closing the
   * connection will close the underlying connection to the database.
   * @param vertx the vertx instance
   * @param options the connect options
   * @return 
   */
  public static Single<io.vertx.reactivex.pgclient.PgConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, PgConnectOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(vertx, options, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from the environment variables.
   * @param vertx 
   * @param handler 
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, Handler<AsyncResult<io.vertx.reactivex.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>() {
      public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.pgclient.PgConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from the environment variables.
   * @param vertx 
   * @return 
   */
  public static Single<io.vertx.reactivex.pgclient.PgConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(vertx, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, String connectionUri, Handler<AsyncResult<io.vertx.reactivex.pgclient.PgConnection>> handler) { 
    io.vertx.pgclient.PgConnection.connect(vertx.getDelegate(), connectionUri, new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>() {
      public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.pgclient.PgConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.pgclient.PgConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static Single<io.vertx.reactivex.pgclient.PgConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, String connectionUri) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(vertx, connectionUri, handler);
    });
  }

  /**
   * Set an handler called when the connection receives notification on a channel.
   * <p/>
   * The handler is called with the {@link io.vertx.pgclient.PgNotification} and has access to the channel name
   * and the notification payload.
   * @param handler the handler
   * @return the transaction instance
   */
  public io.vertx.reactivex.pgclient.PgConnection notificationHandler(Handler<PgNotification> handler) { 
    delegate.notificationHandler(handler);
    return this;
  }

  /**
   * Send a request cancellation message to tell the server to cancel processing request in this connection.
   * <br>Note: Use this with caution because the cancellation signal may or may not have any effect.
   * @param handler the handler notified if cancelling request is sent
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.PgConnection cancelRequest(Handler<AsyncResult<Void>> handler) { 
    io.vertx.reactivex.pgclient.PgConnection ret = io.vertx.reactivex.pgclient.PgConnection.newInstance(delegate.cancelRequest(handler));
    return ret;
  }

  /**
   * @return The process ID of the target backend
   */
  public int processId() { 
    int ret = delegate.processId();
    return ret;
  }

  /**
   * @return The secret key for the target backend
   */
  public int secretKey() { 
    int ret = delegate.secretKey();
    return ret;
  }

  public io.vertx.reactivex.pgclient.PgConnection prepare(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.PreparedQuery>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.PreparedQuery.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.PreparedQuery> rxPrepare(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      prepare(sql, handler);
    });
  }

  public io.vertx.reactivex.pgclient.PgConnection exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.pgclient.PgConnection closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.reactivex.pgclient.PgConnection preparedQuery(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, handler);
    });
  }

  public io.vertx.reactivex.pgclient.PgConnection query(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.query(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      query(sql, handler);
    });
  }

  public io.vertx.reactivex.pgclient.PgConnection preparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, arguments.getDelegate(), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, arguments, handler);
    });
  }

  public io.vertx.reactivex.pgclient.PgConnection preparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedBatch(sql, batch, handler);
    });
  }


  public static  PgConnection newInstance(io.vertx.pgclient.PgConnection arg) {
    return arg != null ? new PgConnection(arg) : null;
  }
}
