/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.pgclient.pubsub;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * A class for managing subscriptions using <code>LISTEN/UNLISTEN</code> to Postgres channels.
 * <p/>
 * The subscriber manages a single connection to Postgres.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.pubsub.PgSubscriber original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.pgclient.pubsub.PgSubscriber.class)
public class PgSubscriber {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgSubscriber that = (PgSubscriber) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<PgSubscriber> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new PgSubscriber((io.vertx.pgclient.pubsub.PgSubscriber) obj),
    PgSubscriber::getDelegate
  );

  private final io.vertx.pgclient.pubsub.PgSubscriber delegate;
  
  public PgSubscriber(io.vertx.pgclient.pubsub.PgSubscriber delegate) {
    this.delegate = delegate;
  }

  public io.vertx.pgclient.pubsub.PgSubscriber getDelegate() {
    return delegate;
  }

  /**
   * Create a subscriber.
   * @param vertx the vertx instance
   * @param options the connect options
   * @return the subscriber
   */
  public static io.vertx.reactivex.pgclient.pubsub.PgSubscriber subscriber(io.vertx.reactivex.core.Vertx vertx, PgConnectOptions options) { 
    io.vertx.reactivex.pgclient.pubsub.PgSubscriber ret = io.vertx.reactivex.pgclient.pubsub.PgSubscriber.newInstance(io.vertx.pgclient.pubsub.PgSubscriber.subscriber(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Return a channel for the given <code>name</code>.
   * @param name the channel name <p/> This will be the name of the channel exactly as held by Postgres for sending notifications. Internally this name will be truncated to the Postgres identifier maxiumum length of <code>(NAMEDATALEN = 64) - 1 == 63</code> characters, and prepared as a quoted identifier without unicode escape sequence support for use in <code>LISTEN/UNLISTEN</code> commands. Examples of channel names and corresponding <code>NOTIFY</code> commands: <ul> <li>when <code>name == "the_channel"</code>: <code>NOTIFY the_channel, 'msg'</code>, <code>NOTIFY The_Channel, 'msg'</code>, or <code>NOTIFY "the_channel", 'msg'</code> succeed in delivering a message to the created channel </li> <li>when <code>name == "The_Channel"</code>: <code>NOTIFY "The_Channel", 'msg'</code>, succeeds in delivering a message to the created channel </li> <li></li> </ul>
   * @return the channel
   */
  public io.vertx.reactivex.pgclient.pubsub.PgChannel channel(String name) { 
    io.vertx.reactivex.pgclient.pubsub.PgChannel ret = io.vertx.reactivex.pgclient.pubsub.PgChannel.newInstance(delegate.channel(name));
    return ret;
  }

  /**
   * Connect the subscriber to Postgres.
   * @param handler the handler notified of the connection success or failure
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgSubscriber connect(Handler<AsyncResult<Void>> handler) { 
    delegate.connect(handler);
    return this;
  }

  /**
   * Connect the subscriber to Postgres.
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxConnect() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      connect(handler);
    });
  }

  /**
   * Set the reconnect policy that is executed when the subscriber is disconnected.
   * <p/>
   * When the subscriber is disconnected, the <code>policy</code> function is called with the actual
   * number of retries and returns an <code>amountOfTime</code> value:
   * <ul>
   *   <li>when <code>amountOfTime < 0</code>: the subscriber is closed and there is no retry</li>
   *   <li>when <code>amountOfTime == 0</code>: the subscriber retries to connect immediately</li>
   *   <li>when <code>amountOfTime > 0</code>: the subscriber retries after <code>amountOfTime</code> milliseconds</li>
   * </ul>
   * <p/>
   * The default policy does not perform any retries.
   * @param policy the policy to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgSubscriber reconnectPolicy(Function<Integer, Long> policy) { 
    delegate.reconnectPolicy(policy);
    return this;
  }

  /**
   * Set an handler called when the subscriber is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.pgclient.pubsub.PgSubscriber closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @return the actual connection to Postgres, it might be <code>null</code>
   */
  public io.vertx.reactivex.pgclient.PgConnection actualConnection() { 
    io.vertx.reactivex.pgclient.PgConnection ret = io.vertx.reactivex.pgclient.PgConnection.newInstance(delegate.actualConnection());
    return ret;
  }

  /**
   * @return whether the subscriber is closed
   */
  public boolean closed() { 
    boolean ret = delegate.closed();
    return ret;
  }

  /**
   * Close the subscriber, the retry policy will not be invoked.
   */
  public void close() { 
    delegate.close();
  }


  public static  PgSubscriber newInstance(io.vertx.pgclient.pubsub.PgSubscriber arg) {
    return arg != null ? new PgSubscriber(arg) : null;
  }
}
