/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * Container for a script and its sha1 hash.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.Script original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.redis.Script.class)
public class Script {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Script that = (Script) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Script> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Script((io.vertx.redis.Script) obj),
    Script::getDelegate
  );

  private final io.vertx.redis.Script delegate;
  
  public Script(io.vertx.redis.Script delegate) {
    this.delegate = delegate;
  }

  public io.vertx.redis.Script getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.redis.Script create(String script) { 
    io.vertx.reactivex.redis.Script ret = io.vertx.reactivex.redis.Script.newInstance(io.vertx.redis.Script.create(script));
    return ret;
  }

  public static io.vertx.reactivex.redis.Script create(String script, String sha1) { 
    io.vertx.reactivex.redis.Script ret = io.vertx.reactivex.redis.Script.newInstance(io.vertx.redis.Script.create(script, sha1));
    return ret;
  }

  public String getScript() { 
    String ret = delegate.getScript();
    return ret;
  }

  public String getSha1() { 
    String ret = delegate.getSha1();
    return ret;
  }


  public static  Script newInstance(io.vertx.redis.Script arg) {
    return arg != null ? new Script(arg) : null;
  }
}
