/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.servicediscovery.Record;

/**
 * Once a consumer has chosen a service, it builds a {@link io.vertx.reactivex.servicediscovery.ServiceReference} managing the binding with the chosen
 * service provider.
 * <p>
 * The reference lets the consumer:
 * * access the service (via a proxy or a client) with the {@link io.vertx.reactivex.servicediscovery.ServiceReference#get} method
 * * release the reference - so the binding between the consumer and the provider is removed
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.ServiceReference original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.servicediscovery.ServiceReference.class)
public class ServiceReference {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceReference that = (ServiceReference) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ServiceReference> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ServiceReference((io.vertx.servicediscovery.ServiceReference) obj),
    ServiceReference::getDelegate
  );

  private final io.vertx.servicediscovery.ServiceReference delegate;
  
  public ServiceReference(io.vertx.servicediscovery.ServiceReference delegate) {
    this.delegate = delegate;
  }

  public io.vertx.servicediscovery.ServiceReference getDelegate() {
    return delegate;
  }

  /**
   * @return the service record.
   */
  public Record record() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Record ret = delegate.record();
    cached_0 = ret;
    return ret;
  }

  /**
   * Gets the object to access the service. It can be a proxy, a client or whatever object. The type depends on the
   * service type and the server itself. This method returns the Java version and primary facet of the object, use
   * {@link io.vertx.reactivex.servicediscovery.ServiceReference#getAs} to retrieve the polyglot instance of the object or another facet..
   * @return the object to access the service
   */
  public <T> T get() { 
    T ret = (T) delegate.get();
    return ret;
  }

  /**
   * Gets the object to access the service. It can be a proxy, a client or whatever object. The type depends on the
   * service type and the server itself. This method wraps the service object into the desired type.
   * @param x the type of object
   * @return the object to access the service wrapped to the given type
   */
  public <X> X getAs(Class<X> x) { 
    X ret = (X)io.vertx.lang.rx.TypeArg.of(x).wrap(delegate.getAs(io.vertx.lang.reactivex.Helper.unwrap(x)));
    return ret;
  }

  /**
   * Gets the service object if already retrieved. It won't try to acquire the service object if not retrieved yet.
   * Unlike {@link io.vertx.reactivex.servicediscovery.ServiceReference#cached}, this method return the warpped object to the desired (given) type.
   * @param x the type of object
   * @return the object, <code>null</code> if not yet retrieved
   */
  public <X> X cachedAs(Class<X> x) { 
    X ret = (X)io.vertx.lang.rx.TypeArg.of(x).wrap(delegate.cachedAs(io.vertx.lang.reactivex.Helper.unwrap(x)));
    return ret;
  }

  /**
   * Gets the service object if already retrieved. It won't try to acquire the service object if not retrieved yet.
   * @return the object, <code>null</code> if not yet retrieved
   */
  public <T> T cached() { 
    T ret = (T) delegate.cached();
    return ret;
  }

  /**
   * Releases the reference. Once released, the consumer must not use the reference anymore.
   * This method must be idempotent and defensive, as multiple call may happen.
   */
  public void release() { 
    delegate.release();
  }

  /**
   * Checks whether or not the service reference has the given service object.
   * @param object the service object, must not be <code>null</code>
   * @return <code>true</code> if the service reference service object is equal to the given object, <code>false</code> otherwise.
   */
  public boolean isHolding(Object object) { 
    boolean ret = delegate.isHolding(object);
    return ret;
  }

  private Record cached_0;

  public static  ServiceReference newInstance(io.vertx.servicediscovery.ServiceReference arg) {
    return arg != null ? new ServiceReference(arg) : null;
  }
}
