/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A prepared query.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedQuery original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.PreparedQuery.class)
public class PreparedQuery {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedQuery that = (PreparedQuery) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<PreparedQuery> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new PreparedQuery((io.vertx.sqlclient.PreparedQuery) obj),
    PreparedQuery::getDelegate
  );

  private final io.vertx.sqlclient.PreparedQuery delegate;
  
  public PreparedQuery(io.vertx.sqlclient.PreparedQuery delegate) {
    this.delegate = delegate;
  }

  public io.vertx.sqlclient.PreparedQuery getDelegate() {
    return delegate;
  }

  /**
   * Calls {@link io.vertx.reactivex.sqlclient.PreparedQuery#execute} with an empty tuple argument.
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.sqlclient.PreparedQuery execute(Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.execute(new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Calls {@link io.vertx.reactivex.sqlclient.PreparedQuery#execute} with an empty tuple argument.
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxExecute() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      execute(handler);
    });
  }

  /**
   * Create a cursor with the provided <code>arguments</code>.
   * @param args the list of arguments
   * @param handler 
   * @return the query
   */
  public io.vertx.reactivex.sqlclient.PreparedQuery execute(io.vertx.reactivex.sqlclient.Tuple args, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.execute(args.getDelegate(), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Create a cursor with the provided <code>arguments</code>.
   * @param args the list of arguments
   * @return the query
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxExecute(io.vertx.reactivex.sqlclient.Tuple args) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      execute(args, handler);
    });
  }

  /**
   * @return create a query cursor with a <code>fetch</code> size and empty arguments
   */
  public io.vertx.reactivex.sqlclient.Cursor cursor() { 
    io.vertx.reactivex.sqlclient.Cursor ret = io.vertx.reactivex.sqlclient.Cursor.newInstance(delegate.cursor());
    return ret;
  }

  /**
   * Create a cursor with the provided <code>arguments</code>.
   * @param args the list of arguments
   * @return the query
   */
  public io.vertx.reactivex.sqlclient.Cursor cursor(io.vertx.reactivex.sqlclient.Tuple args) { 
    io.vertx.reactivex.sqlclient.Cursor ret = io.vertx.reactivex.sqlclient.Cursor.newInstance(delegate.cursor(args.getDelegate()));
    return ret;
  }

  /**
   * Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
   * with a <code>fetch</code> size to fetch the results.
   * <p/>
   * Note: this requires to be in a transaction, since cursors require it.
   * @param fetch the cursor fetch size
   * @param args the prepared query arguments
   * @return the createStream
   */
  public io.vertx.reactivex.sqlclient.RowStream<io.vertx.reactivex.sqlclient.Row> createStream(int fetch, io.vertx.reactivex.sqlclient.Tuple args) { 
    io.vertx.reactivex.sqlclient.RowStream<io.vertx.reactivex.sqlclient.Row> ret = io.vertx.reactivex.sqlclient.RowStream.newInstance(delegate.createStream(fetch, args.getDelegate()), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG);
    return ret;
  }

  /**
   * Execute a batch.
   * @param argsList the list of tuple for the batch
   * @param handler 
   * @return the createBatch
   */
  public io.vertx.reactivex.sqlclient.PreparedQuery batch(List<io.vertx.reactivex.sqlclient.Tuple> argsList, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.batch(argsList.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Execute a batch.
   * @param argsList the list of tuple for the batch
   * @return the createBatch
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxBatch(List<io.vertx.reactivex.sqlclient.Tuple> argsList) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      batch(argsList, handler);
    });
  }

  /**
   * Close the prepared query and release its resources.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.PreparedQuery#close} but notifies the <code>completionHandler</code> when it's closed.
   * @param completionHandler 
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.PreparedQuery#close} but notifies the <code>completionHandler</code> when it's closed.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }


  public static  PreparedQuery newInstance(io.vertx.sqlclient.PreparedQuery arg) {
    return arg != null ? new PreparedQuery(arg) : null;
  }
}
