/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A row oriented stream.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.RowStream original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.RowStream.class)
public class RowStream<T> implements io.vertx.reactivex.core.streams.ReadStream<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RowStream that = (RowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<RowStream> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new RowStream((io.vertx.sqlclient.RowStream) obj),
    RowStream::getDelegate
  );

  private final io.vertx.sqlclient.RowStream<T> delegate;
  public final io.vertx.lang.rx.TypeArg<T> __typeArg_0;
  
  public RowStream(io.vertx.sqlclient.RowStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();  }

  public RowStream(io.vertx.sqlclient.RowStream delegate, io.vertx.lang.rx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.RowStream getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<T> observable;
  private io.reactivex.Flowable<T> flowable;

  public synchronized io.reactivex.Observable<T> toObservable() {
    if (observable == null) {
      java.util.function.Function<T, T> conv = (java.util.function.Function<T, T>) __typeArg_0.wrap;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<T> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<T, T> conv = (java.util.function.Function<T, T>) __typeArg_0.wrap;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.ReadStream<T> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<T> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<T> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), __typeArg_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<T> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<T> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<T> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.sqlclient.RowStream<T> exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.sqlclient.RowStream<T> handler(Handler<T> handler) { 
    delegate.handler(new Handler<T>() {
      public void handle(T event) {
        handler.handle((T)__typeArg_0.wrap(event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.sqlclient.RowStream<T> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.sqlclient.RowStream<T> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.sqlclient.RowStream<T> endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Close the stream and release the resources.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the stream and release the resources.
   * @param completionHandler the completion handler for this operation
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the stream and release the resources.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }


  public static <T>RowStream<T> newInstance(io.vertx.sqlclient.RowStream arg) {
    return arg != null ? new RowStream<T>(arg) : null;
  }

  public static <T>RowStream<T> newInstance(io.vertx.sqlclient.RowStream arg, io.vertx.lang.rx.TypeArg<T> __typeArg_T) {
    return arg != null ? new RowStream<T>(arg, __typeArg_T) : null;
  }
}
