/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A connection to database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlConnection original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection extends io.vertx.reactivex.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlConnection that = (SqlConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SqlConnection> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection) obj),
    SqlConnection::getDelegate
  );

  private final io.vertx.sqlclient.SqlConnection delegate;
  
  public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.sqlclient.SqlConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a prepared query.
   * @param sql the sql
   * @param handler the handler notified with the prepared query asynchronously
   * @return 
   */
  public io.vertx.reactivex.sqlclient.SqlConnection prepare(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.PreparedQuery>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.PreparedQuery.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Create a prepared query.
   * @param sql the sql
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.PreparedQuery> rxPrepare(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      prepare(sql, handler);
    });
  }

  /**
   * Set an handler called with connection errors.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlConnection exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an handler called when the connection is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlConnection closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Begin a transaction and returns a {@link io.vertx.reactivex.sqlclient.Transaction} for controlling and tracking
   * this transaction.
   * <p/>
   * When the connection is explicitely closed, any inflight transaction is rollbacked.
   * @return the transaction instance
   */
  public io.vertx.reactivex.sqlclient.Transaction begin() { 
    io.vertx.reactivex.sqlclient.Transaction ret = io.vertx.reactivex.sqlclient.Transaction.newInstance(delegate.begin());
    return ret;
  }

  /**
   * @return whether the connection uses SSL
   */
  public boolean isSSL() { 
    boolean ret = delegate.isSSL();
    return ret;
  }

  /**
   * Close the current connection after all the pending commands have been processed.
   */
  public void close() { 
    delegate.close();
  }

  public io.vertx.reactivex.sqlclient.SqlConnection preparedQuery(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, handler);
    });
  }

  public io.vertx.reactivex.sqlclient.SqlConnection query(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.query(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      query(sql, handler);
    });
  }

  public io.vertx.reactivex.sqlclient.SqlConnection preparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, arguments.getDelegate(), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, arguments, handler);
    });
  }

  public io.vertx.reactivex.sqlclient.SqlConnection preparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedBatch(sql, batch, handler);
    });
  }


  public static  SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
    return arg != null ? new SqlConnection(arg) : null;
  }
}
