/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.time.OffsetTime;
import java.time.LocalDateTime;
import java.util.UUID;
import java.math.BigDecimal;
import java.util.List;
import java.time.OffsetDateTime;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.Temporal;

/**
 * A general purpose tuple.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Tuple original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.Tuple.class)
public class Tuple {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Tuple that = (Tuple) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Tuple> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Tuple((io.vertx.sqlclient.Tuple) obj),
    Tuple::getDelegate
  );

  private final io.vertx.sqlclient.Tuple delegate;
  
  public Tuple(io.vertx.sqlclient.Tuple delegate) {
    this.delegate = delegate;
  }

  public io.vertx.sqlclient.Tuple getDelegate() {
    return delegate;
  }

  /**
   * @return a new empty tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple tuple() { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.tuple());
    return ret;
  }

  /**
   * Wrap the provided <code>list</code> with a tuple.
   * <br/>
   * The list is not copied and is used as store for tuple elements.
   * @param list 
   * @return the list wrapped as a tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple wrap(List<Object> list) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.wrap(list));
    return ret;
  }

  /**
   * Create a tuple of one element.
   * @param elt1 the first value
   * @return the tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple of(Object elt1) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.of(elt1));
    return ret;
  }

  /**
   * Create a tuple of two elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @return the tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple of(Object elt1, Object elt2) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.of(elt1, elt2));
    return ret;
  }

  /**
   * Create a tuple of three elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @return the tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple of(Object elt1, Object elt2, Object elt3) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3));
    return ret;
  }

  /**
   * Create a tuple of four elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @return the tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple of(Object elt1, Object elt2, Object elt3, Object elt4) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4));
    return ret;
  }

  /**
   * Create a tuple of five elements.
   * @param elt1 the first value
   * @param elt2 the second value
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @param elt5 the fifth value
   * @return the tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4, elt5));
    return ret;
  }

  /**
   * Create a tuple of six elements.
   * @param elt1 the first value
   * @param elt2 the second valueg
   * @param elt3 the third value
   * @param elt4 the fourth value
   * @param elt5 the fifth value
   * @param elt6 the sixth value
   * @return the tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5, Object elt6) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.of(elt1, elt2, elt3, elt4, elt5, elt6));
    return ret;
  }

  /**
   * Create a tuple with the provided <code>elements</code> list.
   * <p/>
   * The <code>elements</code> list is not modified.
   * @param elements the list of elements
   * @return the tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple tuple(List<Object> elements) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.tuple(elements));
    return ret;
  }

  /**
   * Get a boolean value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Boolean getBoolean(int pos) { 
    Boolean ret = delegate.getBoolean(pos);
    return ret;
  }

  /**
   * Get an object value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Object getValue(int pos) { 
    Object ret = (Object) delegate.getValue(pos);
    return ret;
  }

  /**
   * Get a short value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Short getShort(int pos) { 
    Short ret = delegate.getShort(pos);
    return ret;
  }

  /**
   * Get an integer value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Integer getInteger(int pos) { 
    Integer ret = delegate.getInteger(pos);
    return ret;
  }

  /**
   * Get a long value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Long getLong(int pos) { 
    Long ret = delegate.getLong(pos);
    return ret;
  }

  /**
   * Get a float value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Float getFloat(int pos) { 
    Float ret = delegate.getFloat(pos);
    return ret;
  }

  /**
   * Get a double value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Double getDouble(int pos) { 
    Double ret = delegate.getDouble(pos);
    return ret;
  }

  /**
   * Get a string value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public String getString(int pos) { 
    String ret = delegate.getString(pos);
    return ret;
  }

  /**
   * Get a buffer value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public io.vertx.reactivex.core.buffer.Buffer getBuffer(int pos) { 
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance(delegate.getBuffer(pos));
    return ret;
  }

  /**
   * Add a boolean value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addBoolean(Boolean value) { 
    delegate.addBoolean(value);
    return this;
  }

  /**
   * Add an object value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addValue(Object value) { 
    delegate.addValue(value);
    return this;
  }

  /**
   * Add a short value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addShort(Short value) { 
    delegate.addShort(value);
    return this;
  }

  /**
   * Add an integer value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addInteger(Integer value) { 
    delegate.addInteger(value);
    return this;
  }

  /**
   * Add a long value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLong(Long value) { 
    delegate.addLong(value);
    return this;
  }

  /**
   * Add a float value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addFloat(Float value) { 
    delegate.addFloat(value);
    return this;
  }

  /**
   * Add a double value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addDouble(Double value) { 
    delegate.addDouble(value);
    return this;
  }

  /**
   * Add a string value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addString(String value) { 
    delegate.addString(value);
    return this;
  }

  /**
   * Add a buffer value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addBuffer(io.vertx.reactivex.core.buffer.Buffer value) { 
    delegate.addBuffer(value.getDelegate());
    return this;
  }

  public <T> T get(Class<T> type, int pos) { 
    T ret = (T)io.vertx.lang.rx.TypeArg.of(type).wrap(delegate.get(io.vertx.lang.reactivex.Helper.unwrap(type), pos));
    return ret;
  }

  /**
   * @return the tuple size
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public void clear() { 
    delegate.clear();
  }

  /**
   * Wrap the provided <code>array</code> with a tuple.
   * <br/>
   * The array is not copied and is used as store for tuple elements.
   * @param array 
   * @return the list wrapped as a tuple
   */
  public static io.vertx.reactivex.sqlclient.Tuple wrap(Object[] array) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(io.vertx.sqlclient.Tuple.wrap(array));
    return ret;
  }

  /**
   * Get a {@link java.time.temporal.Temporal} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Temporal getTemporal(int pos) { 
    Temporal ret = delegate.getTemporal(pos);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDate} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public LocalDate getLocalDate(int pos) { 
    LocalDate ret = delegate.getLocalDate(pos);
    return ret;
  }

  /**
   * Get {@link java.time.LocalTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public LocalTime getLocalTime(int pos) { 
    LocalTime ret = delegate.getLocalTime(pos);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDateTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public LocalDateTime getLocalDateTime(int pos) { 
    LocalDateTime ret = delegate.getLocalDateTime(pos);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public OffsetTime getOffsetTime(int pos) { 
    OffsetTime ret = delegate.getOffsetTime(pos);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetDateTime} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public OffsetDateTime getOffsetDateTime(int pos) { 
    OffsetDateTime ret = delegate.getOffsetDateTime(pos);
    return ret;
  }

  /**
   * Get {@link java.util.UUID} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public UUID getUUID(int pos) { 
    UUID ret = delegate.getUUID(pos);
    return ret;
  }

  /**
   * Get  value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public BigDecimal getBigDecimal(int pos) { 
    BigDecimal ret = delegate.getBigDecimal(pos);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Integer} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Integer[] getIntegerArray(int pos) { 
    Integer[] ret = delegate.getIntegerArray(pos);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Boolean} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Boolean[] getBooleanArray(int pos) { 
    Boolean[] ret = delegate.getBooleanArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.Short} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Short[] getShortArray(int pos) { 
    Short[] ret = delegate.getShortArray(pos);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Long} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Long[] getLongArray(int pos) { 
    Long[] ret = delegate.getLongArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.Float} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Float[] getFloatArray(int pos) { 
    Float[] ret = delegate.getFloatArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.Double} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public Double[] getDoubleArray(int pos) { 
    Double[] ret = delegate.getDoubleArray(pos);
    return ret;
  }

  /**
   * Get an array of  {@link java.lang.String} value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public String[] getStringArray(int pos) { 
    String[] ret = delegate.getStringArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public LocalDate[] getLocalDateArray(int pos) { 
    LocalDate[] ret = delegate.getLocalDateArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public LocalTime[] getLocalTimeArray(int pos) { 
    LocalTime[] ret = delegate.getLocalTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public OffsetTime[] getOffsetTimeArray(int pos) { 
    OffsetTime[] ret = delegate.getOffsetTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public LocalDateTime[] getLocalDateTimeArray(int pos) { 
    LocalDateTime[] ret = delegate.getLocalDateTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of   value at <code>pos</code>.
   * @param pos the position
   * @return the value or <code>null</code>
   */
  public OffsetDateTime[] getOffsetDateTimeArray(int pos) { 
    OffsetDateTime[] ret = delegate.getOffsetDateTimeArray(pos);
    return ret;
  }

  /**
   * Get an array of  value at <code>pos</code>.
   * @param pos the column
   * @return the value or <code>null</code>
   */
  public UUID[] getUUIDArray(int pos) { 
    UUID[] ret = delegate.getUUIDArray(pos);
    return ret;
  }

  /**
   * Add a {@link java.time.temporal.Temporal} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addTemporal(Temporal value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addTemporal(value));
    return ret;
  }

  /**
   * Add a {@link java.time.LocalDate} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLocalDate(LocalDate value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addLocalDate(value));
    return ret;
  }

  /**
   * Add a {@link java.time.LocalTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLocalTime(LocalTime value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addLocalTime(value));
    return ret;
  }

  /**
   * Add a {@link java.time.LocalDateTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLocalDateTime(LocalDateTime value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addLocalDateTime(value));
    return ret;
  }

  /**
   * Add a {@link java.time.OffsetTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addOffsetTime(OffsetTime value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addOffsetTime(value));
    return ret;
  }

  /**
   * Add a {@link java.time.OffsetDateTime} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addOffsetDateTime(OffsetDateTime value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addOffsetDateTime(value));
    return ret;
  }

  /**
   * Add a {@link java.util.UUID} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addUUID(UUID value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addUUID(value));
    return ret;
  }

  /**
   * Add a  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addBigDecimal(BigDecimal value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addBigDecimal(value));
    return ret;
  }

  /**
   * Add an array of <code>Integer</code> value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addIntegerArray(Integer[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addIntegerArray(value));
    return ret;
  }

  /**
   * Add an array of <code>Boolean</code> value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addBooleanArray(Boolean[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addBooleanArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Short} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addShortArray(Short[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addShortArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Long} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLongArray(Long[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addLongArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Float} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addFloatArray(Float[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addFloatArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.Double} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addDoubleArray(Double[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addDoubleArray(value));
    return ret;
  }

  /**
   * Add an array of {@link java.lang.String} value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addStringArray(String[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addStringArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLocalDateArray(LocalDate[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addLocalDateArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLocalTimeArray(LocalTime[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addLocalTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addOffsetTimeArray(OffsetTime[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addOffsetTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addLocalDateTimeArray(LocalDateTime[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addLocalDateTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addOffsetDateTimeArray(OffsetDateTime[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addOffsetDateTimeArray(value));
    return ret;
  }

  /**
   * Add an array of  value at the end of the tuple.
   * @param value the value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Tuple addUUIDArray(UUID[] value) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance(delegate.addUUIDArray(value));
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final Object JSON_NULL = (Object) io.vertx.sqlclient.Tuple.JSON_NULL;

  public static  Tuple newInstance(io.vertx.sqlclient.Tuple arg) {
    return arg != null ? new Tuple(arg) : null;
  }
}
