/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Interface used to consume AMQP message as a stream of message.
 * Back pressure is implemented using AMQP credits.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpReceiver original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.amqp.AmqpReceiver.class)
public class AmqpReceiver implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.amqp.AmqpMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpReceiver that = (AmqpReceiver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<AmqpReceiver> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new AmqpReceiver((io.vertx.amqp.AmqpReceiver) obj),
    AmqpReceiver::getDelegate
  );

  private final io.vertx.amqp.AmqpReceiver delegate;
  
  public AmqpReceiver(io.vertx.amqp.AmqpReceiver delegate) {
    this.delegate = delegate;
  }

  public io.vertx.amqp.AmqpReceiver getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.amqp.AmqpMessage> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.amqp.AmqpMessage> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.amqp.AmqpMessage> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.amqp.AmqpMessage, io.vertx.reactivex.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.amqp.AmqpMessage> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.amqp.AmqpMessage, io.vertx.reactivex.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.amqp.AmqpMessage> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.amqp.AmqpMessage> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.amqp.AmqpMessage.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.amqp.AmqpReceiver exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpReceiver handler(Handler<io.vertx.reactivex.amqp.AmqpMessage> handler) { 
    delegate.handler(new Handler<io.vertx.amqp.AmqpMessage>() {
      public void handle(io.vertx.amqp.AmqpMessage event) {
        handler.handle(io.vertx.reactivex.amqp.AmqpMessage.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpReceiver pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpReceiver resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpReceiver fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpReceiver endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * The listened address.
   * @return the address, not <code>null</code>
   */
  public String address() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.address();
    cached_0 = ret;
    return ret;
  }

  /**
   * Closes the receiver.
   * @param handler handler called when the receiver has been closed, can be <code>null</code>
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the receiver.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Gets the connection having created the receiver. Cannot be <code>null</code>
   * @return the connection having created the receiver.
   */
  public io.vertx.reactivex.amqp.AmqpConnection connection() { 
    io.vertx.reactivex.amqp.AmqpConnection ret = io.vertx.reactivex.amqp.AmqpConnection.newInstance(delegate.connection());
    return ret;
  }

  private String cached_0;

  public static  AmqpReceiver newInstance(io.vertx.amqp.AmqpReceiver arg) {
    return arg != null ? new AmqpReceiver(arg) : null;
  }
}
