/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import com.datastax.driver.core.Row;
import io.vertx.cassandra.CassandraClientOptions;
import com.datastax.driver.core.PreparedStatement;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import com.datastax.driver.core.Statement;

/**
 * Eclipse Vert.x Cassandra client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraClient that = (CassandraClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CassandraClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CassandraClient((io.vertx.cassandra.CassandraClient) obj),
    CassandraClient::getDelegate
  );

  private final io.vertx.cassandra.CassandraClient delegate;
  
  public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.cassandra.CassandraClient getDelegate() {
    return delegate;
  }

  /**
   * @param vertx 
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.cassandra.CassandraClient createNonShared(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createNonShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#create} with default options.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx 
   * @param options 
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.cassandra.CassandraClient createNonShared(io.vertx.reactivex.core.Vertx vertx, CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createNonShared(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a Cassandra client which maintains its own driver session.
   * <p>
   * It is not recommended to create several non shared clients in an application.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.cassandra.CassandraClient create(io.vertx.reactivex.core.Vertx vertx, CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default options and client name.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default options.
   * @param vertx 
   * @param clientName 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, String clientName) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default client name.
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a Cassandra client that shares its driver session with any other client having the same name.
   * @param vertx the Vert.x instance
   * @param clientName the shared client name
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, String clientName, CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName, options));
    return ret;
  }

  /**
   * @return whether this Cassandra client instance is connected
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @param resultHandler handler called when result of execution is present, but can be not fully fetched
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient execute(String query, Handler<AsyncResult<io.vertx.reactivex.cassandra.ResultSet>> resultHandler) { 
    delegate.execute(query, new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>() {
      public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.cassandra.ResultSet.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public Single<io.vertx.reactivex.cassandra.ResultSet> rxExecute(String query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      execute(query, handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param rowStreamHandler the handler which is called once the operation completes. It will return an instance of {@link io.vertx.reactivex.cassandra.CassandraRowStream}.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient queryStream(String sql, Handler<AsyncResult<io.vertx.reactivex.cassandra.CassandraRowStream>> rowStreamHandler) { 
    delegate.queryStream(sql, new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>() {
      public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
        if (ar.succeeded()) {
          rowStreamHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.cassandra.CassandraRowStream.newInstance(ar.result())));
        } else {
          rowStreamHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return current Cassandra client instance
   */
  public Single<io.vertx.reactivex.cassandra.CassandraRowStream> rxQueryStream(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      queryStream(sql, handler);
    });
  }

  /**
   * Closes this client.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient close() { 
    delegate.close();
    return this;
  }

  /**
   * Closes this client.
   * @param closeHandler handler called when client is closed
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient close(Handler<AsyncResult<Void>> closeHandler) { 
    delegate.close(closeHandler);
    return this;
  }

  /**
   * Closes this client.
   * @return current Cassandra client instance
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @param resultHandler handler called when result of execution is fully fetched.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient executeWithFullFetch(String query, Handler<AsyncResult<List<Row>>> resultHandler) { 
    delegate.executeWithFullFetch(query, resultHandler);
    return this;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public Single<List<Row>> rxExecuteWithFullFetch(String query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executeWithFullFetch(query, handler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @param resultHandler handler called when result of execution is fully fetched.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient executeWithFullFetch(Statement statement, Handler<AsyncResult<List<Row>>> resultHandler) { 
    delegate.executeWithFullFetch(statement, resultHandler);
    return this;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public Single<List<Row>> rxExecuteWithFullFetch(Statement statement) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executeWithFullFetch(statement, handler);
    });
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @param resultHandler handler called when result of execution is present
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient execute(Statement statement, Handler<AsyncResult<io.vertx.reactivex.cassandra.ResultSet>> resultHandler) { 
    delegate.execute(statement, new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>() {
      public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.cassandra.ResultSet.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public Single<io.vertx.reactivex.cassandra.ResultSet> rxExecute(Statement statement) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      execute(statement, handler);
    });
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @param resultHandler handler called when result of query preparation is present
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient prepare(String query, Handler<AsyncResult<PreparedStatement>> resultHandler) { 
    delegate.prepare(query, resultHandler);
    return this;
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @return current Cassandra client instance
   */
  public Single<PreparedStatement> rxPrepare(String query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      prepare(query, handler);
    });
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @param rowStreamHandler the handler which is called once the operation completes. It will return an instance of {@link io.vertx.reactivex.cassandra.CassandraRowStream}.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient queryStream(Statement statement, Handler<AsyncResult<io.vertx.reactivex.cassandra.CassandraRowStream>> rowStreamHandler) { 
    delegate.queryStream(statement, new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>() {
      public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
        if (ar.succeeded()) {
          rowStreamHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.cassandra.CassandraRowStream.newInstance(ar.result())));
        } else {
          rowStreamHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @return current Cassandra client instance
   */
  public Single<io.vertx.reactivex.cassandra.CassandraRowStream> rxQueryStream(Statement statement) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      queryStream(statement, handler);
    });
  }

  /**
   * The default shared client name.
   */
  public static final String DEFAULT_SHARED_CLIENT_NAME = io.vertx.cassandra.CassandraClient.DEFAULT_SHARED_CLIENT_NAME;

  public static  CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
    return arg != null ? new CassandraClient(arg) : null;
  }
}
