/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.circuitbreaker;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import java.util.function.Function;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An implementation of the circuit breaker pattern for Vert.x
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.CircuitBreaker original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.circuitbreaker.CircuitBreaker.class)
public class CircuitBreaker {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CircuitBreaker that = (CircuitBreaker) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CircuitBreaker> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CircuitBreaker((io.vertx.circuitbreaker.CircuitBreaker) obj),
    CircuitBreaker::getDelegate
  );

  private final io.vertx.circuitbreaker.CircuitBreaker delegate;
  
  public CircuitBreaker(io.vertx.circuitbreaker.CircuitBreaker delegate) {
    this.delegate = delegate;
  }

  public io.vertx.circuitbreaker.CircuitBreaker getDelegate() {
    return delegate;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}.
   * @param name the name
   * @param vertx the Vert.x instance
   * @param options the configuration option
   * @return the created instance
   */
  public static io.vertx.reactivex.circuitbreaker.CircuitBreaker create(String name, io.vertx.reactivex.core.Vertx vertx, CircuitBreakerOptions options) { 
    io.vertx.reactivex.circuitbreaker.CircuitBreaker ret = io.vertx.reactivex.circuitbreaker.CircuitBreaker.newInstance(io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}, with default options.
   * @param name the name
   * @param vertx the Vert.x instance
   * @return the created instance
   */
  public static io.vertx.reactivex.circuitbreaker.CircuitBreaker create(String name, io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.circuitbreaker.CircuitBreaker ret = io.vertx.reactivex.circuitbreaker.CircuitBreaker.newInstance(io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate()));
    return ret;
  }

  /**
   * Closes the circuit breaker. It stops sending events on its state on the event bus.
   * This method is not related to the <code>close</code> state of the circuit breaker. To set the circuit breaker in the
   * <code>close</code> state, use {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#reset}.
   * @return 
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker close() { 
    delegate.close();
    return this;
  }

  /**
   * Sets a  invoked when the circuit breaker state switches to open.
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker openHandler(Handler<Void> handler) { 
    delegate.openHandler(handler);
    return this;
  }

  /**
   * Sets a  invoked when the circuit breaker state switches to half-open.
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker halfOpenHandler(Handler<Void> handler) { 
    delegate.halfOpenHandler(handler);
    return this;
  }

  /**
   * Sets a  invoked when the circuit breaker state switches to close.
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using a callback.
   * @param command the operation
   * @param fallback the fallback
   * @param handler the completion handler receiving either the operation result or the fallback result. The parameter is an  because if the fallback is not called, the error is passed to the handler.
   */
  public <T> void executeWithFallback(Handler<io.vertx.reactivex.core.Promise<T>> command, Function<Throwable, T> fallback, Handler<AsyncResult<T>> handler) { 
    delegate.executeWithFallback(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.reactivex.core.Promise.newInstance(event, io.vertx.lang.rx.TypeArg.unknown()));
      }
    }, fallback, handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using a callback.
   * @param command the operation
   * @param fallback the fallback
   * @return 
   */
  public <T> Single<T> rxExecuteWithFallback(Handler<io.vertx.reactivex.core.Promise<T>> command, Function<Throwable, T> fallback) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executeWithFallback(command, fallback, handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using a callback.
   * @param command the operation
   * @param fallback the fallback
   * @param handler the completion handler receiving either the operation result or the fallback result. The parameter is an  because if the fallback is not called, the error is passed to the handler.
   */
  @Deprecated()
  public <T> void executeCommandWithFallback(Handler<io.vertx.reactivex.core.Promise<T>> command, Function<Throwable, T> fallback, Handler<AsyncResult<T>> handler) { 
    delegate.executeCommandWithFallback(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.reactivex.core.Promise.newInstance(event, io.vertx.lang.rx.TypeArg.unknown()));
      }
    }, fallback, handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using a callback.
   * @param command the operation
   * @param fallback the fallback
   * @return 
   */
  @Deprecated()
  public <T> Single<T> rxExecuteCommandWithFallback(Handler<io.vertx.reactivex.core.Promise<T>> command, Function<Throwable, T> fallback) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executeCommandWithFallback(command, fallback, handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker default fallback.
   * @param command the operation
   * @param handler the completion handler receiving either the operation result or the fallback result. The parameter is an  because if the fallback is not called, the error is passed to the handler.
   */
  public <T> void execute(Handler<io.vertx.reactivex.core.Promise<T>> command, Handler<AsyncResult<T>> handler) { 
    delegate.execute(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.reactivex.core.Promise.newInstance(event, io.vertx.lang.rx.TypeArg.unknown()));
      }
    }, handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker default fallback.
   * @param command the operation
   * @return 
   */
  public <T> Single<T> rxExecute(Handler<io.vertx.reactivex.core.Promise<T>> command) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      execute(command, handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker default fallback.
   * @param command the operation
   * @param handler the completion handler receiving either the operation result or the fallback result. The parameter is an  because if the fallback is not called, the error is passed to the handler.
   */
  @Deprecated()
  public <T> void executeCommand(Handler<io.vertx.reactivex.core.Promise<T>> command, Handler<AsyncResult<T>> handler) { 
    delegate.executeCommand(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.reactivex.core.Promise.newInstance(event, io.vertx.lang.rx.TypeArg.unknown()));
      }
    }, handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker default fallback.
   * @param command the operation
   * @return 
   */
  @Deprecated()
  public <T> Single<T> rxExecuteCommand(Handler<io.vertx.reactivex.core.Promise<T>> command) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executeCommand(command, handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeAndReportWithFallback} but using the circuit breaker default
   * fallback.
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.reactivex.circuitbreaker.CircuitBreaker executeAndReport(io.vertx.reactivex.core.Promise<T> resultPromise, Handler<io.vertx.reactivex.core.Promise<T>> command) { 
    delegate.executeAndReport(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.reactivex.core.Promise.newInstance(event, resultPromise.__typeArg_0));
      }
    });
    return this;
  }

  /**
   * Executes the given operation with the circuit breaker control. The operation is generally calling an
   * <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
   * call  when the operation has terminated successfully. The operation must also
   * call  in case of failure.
   * <p>
   * The operation is not invoked if the circuit breaker is open, and the given fallback is called immediately. The
   * circuit breaker also monitor the completion of the operation before a configure timeout. The operation is
   * considered as failed if it does not terminate in time.
   * <p>
   * Unlike {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback},  this method does return a  object, but
   * let the caller pass a  object on which the result is reported. If the fallback is called, the promise
   * is successfully completed with the value returned by the fallback function. If the fallback throws an exception,
   * the promise is marked as failed.
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @param fallback the fallback function. It gets an exception as parameter and returns the <em>fallback</em> result
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.reactivex.circuitbreaker.CircuitBreaker executeAndReportWithFallback(io.vertx.reactivex.core.Promise<T> resultPromise, Handler<io.vertx.reactivex.core.Promise<T>> command, Function<Throwable, T> fallback) { 
    delegate.executeAndReportWithFallback(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.reactivex.core.Promise.newInstance(event, resultPromise.__typeArg_0));
      }
    }, fallback);
    return this;
  }

  /**
   * Sets a <em>default</em>  invoked when the bridge is open to handle the "request", or on failure
   * if {@link io.vertx.circuitbreaker.CircuitBreakerOptions} is enabled.
   * <p>
   * The function gets the exception as parameter and returns the <em>fallback</em> result.
   * @param handler the handler
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.reactivex.circuitbreaker.CircuitBreaker fallback(Function<Throwable, T> handler) { 
    delegate.fallback(handler);
    return this;
  }

  /**
   * Resets the circuit breaker state (number of failure set to 0 and state set to closed).
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker reset() { 
    delegate.reset();
    return this;
  }

  /**
   * Explicitly opens the circuit.
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker open() { 
    delegate.open();
    return this;
  }

  /**
   * @return the current state.
   */
  public CircuitBreakerState state() { 
    CircuitBreakerState ret = delegate.state();
    return ret;
  }

  /**
   * @return the current number of failures.
   */
  public long failureCount() { 
    long ret = delegate.failureCount();
    return ret;
  }

  /**
   * @return the name of the circuit breaker.
   */
  public String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  public io.vertx.reactivex.circuitbreaker.CircuitBreaker retryPolicy(Function<Integer, Long> retryPolicy) { 
    delegate.retryPolicy(retryPolicy);
    return this;
  }

  private String cached_0;

  public static  CircuitBreaker newInstance(io.vertx.circuitbreaker.CircuitBreaker arg) {
    return arg != null ? new CircuitBreaker(arg) : null;
  }
}
