/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.dns;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Provides a way to asynchronously lookup information from DNS servers.
 * <p>
 * Please consult the documentation for more information on DNS clients.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.DnsClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.dns.DnsClient.class)
public class DnsClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DnsClient that = (DnsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<DnsClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new DnsClient((io.vertx.core.dns.DnsClient) obj),
    DnsClient::getDelegate
  );

  private final io.vertx.core.dns.DnsClient delegate;
  
  public DnsClient(io.vertx.core.dns.DnsClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.dns.DnsClient getDelegate() {
    return delegate;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with the resolved address if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.dns.DnsClient lookup(String name, Handler<AsyncResult<String>> handler) { 
    delegate.lookup(name, handler);
    return this;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Maybe<String> rxLookup(String name) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lookup(name, handler);
    });
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the  to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with the resolved {@link java.net.Inet4Address} if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.dns.DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) { 
    delegate.lookup4(name, handler);
    return this;
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Maybe<String> rxLookup4(String name) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lookup4(name, handler);
    });
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.net.Inet6Address} if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.dns.DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) { 
    delegate.lookup6(name, handler);
    return this;
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Maybe<String> rxLookup6(String name) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      lookup6(name, handler);
    });
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet4Address}es. If none was found an empty {@link java.util.List} will be used. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.dns.DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveA(name, handler);
    return this;
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Single<List<String>> rxResolveA(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      resolveA(name, handler);
    });
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet6Address}es. If none was found an empty {@link java.util.List} will be used. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.dns.DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveAAAA(name, handler);
    return this;
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Single<List<String>> rxResolveAAAA(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      resolveAAAA(name, handler);
    });
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.reactivex.core.dns.DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveCNAME(name, handler);
    return this;
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a reference to this, so the API can be used fluently.
   */
  public Single<List<String>> rxResolveCNAME(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      resolveCNAME(name, handler);
    });
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a List that contains all resolved {@link io.vertx.reactivex.core.dns.MxRecord}s, sorted by their {@link io.vertx.reactivex.core.dns.MxRecord#priority}. If non was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.reactivex.core.dns.DnsClient resolveMX(String name, Handler<AsyncResult<List<io.vertx.reactivex.core.dns.MxRecord>>> handler) { 
    delegate.resolveMX(name, new Handler<AsyncResult<java.util.List<io.vertx.core.dns.MxRecord>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.core.dns.MxRecord>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.core.dns.MxRecord.newInstance(elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Single<List<io.vertx.reactivex.core.dns.MxRecord>> rxResolveMX(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      resolveMX(name, handler);
    });
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.reactivex.core.dns.DnsClient resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveTXT(name, handler);
    return this;
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Single<List<String>> rxResolveTXT(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      resolveTXT(name, handler);
    });
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.reactivex.core.dns.DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) { 
    delegate.resolvePTR(name, handler);
    return this;
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public Maybe<String> rxResolvePTR(String name) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      resolvePTR(name, handler);
    });
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.reactivex.core.dns.DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveNS(name, handler);
    return this;
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Single<List<String>> rxResolveNS(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      resolveNS(name, handler);
    });
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link io.vertx.reactivex.core.dns.SrvRecord}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.reactivex.core.dns.DnsClient resolveSRV(String name, Handler<AsyncResult<List<io.vertx.reactivex.core.dns.SrvRecord>>> handler) { 
    delegate.resolveSRV(name, new Handler<AsyncResult<java.util.List<io.vertx.core.dns.SrvRecord>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.core.dns.SrvRecord>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.reactivex.core.dns.SrvRecord.newInstance(elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Single<List<io.vertx.reactivex.core.dns.SrvRecord>> rxResolveSRV(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      resolveSRV(name, handler);
    });
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  public io.vertx.reactivex.core.dns.DnsClient reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) { 
    delegate.reverseLookup(ipaddress, handler);
    return this;
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public Maybe<String> rxReverseLookup(String ipaddress) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      reverseLookup(ipaddress, handler);
    });
  }


  public static  DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
    return arg != null ? new DnsClient(arg) : null;
  }
}
