/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a client-side WebSocket.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.http.WebSocket.class)
public class WebSocket implements io.vertx.reactivex.core.http.WebSocketBase {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocket that = (WebSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<WebSocket> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new WebSocket((io.vertx.core.http.WebSocket) obj),
    WebSocket::getDelegate
  );

  private final io.vertx.core.http.WebSocket delegate;
  
  public WebSocket(io.vertx.core.http.WebSocket delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.WebSocket getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      observable = io.vertx.reactivex.ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      flowable = io.vertx.reactivex.FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private io.vertx.reactivex.WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
  private io.vertx.reactivex.WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;

  public synchronized io.vertx.reactivex.WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      java.util.function.Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      observer = io.vertx.reactivex.RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized io.vertx.reactivex.WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      subscriber = io.vertx.reactivex.RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.http.WebSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance(delegate.pipe(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Returns the status code received when the WebSocket was closed by the other side, otherwise <code>null</code>.
   * @return 
   */
  public Short closeStatusCode() { 
    Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * Returns the reason message received when the WebSocket was closed by the other side, otherwise <code>null</code>.
   * @return 
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase writePing(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.writePing(data.getDelegate());
    return this;
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase writePong(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.writePong(data.getDelegate());
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.reactivex.core.http.WebSocket#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.reactivex.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase binaryMessageHandler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.WebSocketBase pongHandler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#close}
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#close}
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#close}
   * @return 
   */
  public Completable rxEnd() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(handler);
    });
  }

  /**
   * Close the WebSocket sending the default close frame.
   * <p/>
   * No more messages can be sent.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Close the WebSocket sending a close frame with specified status code. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   */
  public void close(short statusCode) { 
    delegate.close(statusCode);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  public void close(short statusCode, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public Completable rxClose(short statusCode) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(statusCode, handler);
    });
  }

  /**
   * Close sending a close frame with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   * @param reason reason of closure
   */
  public void close(short statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public Completable rxClose(short statusCode, String reason) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(statusCode, reason, handler);
    });
  }

  /**
   * @return the remote address for this socket
   */
  public io.vertx.reactivex.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this socket
   */
  public io.vertx.reactivex.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.reactivex.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public io.vertx.reactivex.core.http.WebSocket exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket write(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  public io.vertx.reactivex.core.http.WebSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket writeFrame(io.vertx.reactivex.core.http.WebSocketFrame frame) { 
    delegate.writeFrame(frame.getDelegate());
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket writeFrame(io.vertx.reactivex.core.http.WebSocketFrame frame, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

  public Completable rxWriteFrame(io.vertx.reactivex.core.http.WebSocketFrame frame) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      writeFrame(frame, handler);
    });
  }

  public io.vertx.reactivex.core.http.WebSocket writeFinalTextFrame(String text) { 
    delegate.writeFinalTextFrame(text);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

  public Completable rxWriteFinalTextFrame(String text) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      writeFinalTextFrame(text, handler);
    });
  }

  public io.vertx.reactivex.core.http.WebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.writeFinalBinaryFrame(data.getDelegate());
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

  public Completable rxWriteFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      writeFinalBinaryFrame(data, handler);
    });
  }

  public io.vertx.reactivex.core.http.WebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.writeBinaryMessage(data.getDelegate());
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

  public Completable rxWriteBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      writeBinaryMessage(data, handler);
    });
  }

  public io.vertx.reactivex.core.http.WebSocket writeTextMessage(String text) { 
    delegate.writeTextMessage(text);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket writeTextMessage(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

  public Completable rxWriteTextMessage(String text) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      writeTextMessage(text, handler);
    });
  }

  public io.vertx.reactivex.core.http.WebSocket closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.WebSocket frameHandler(Handler<io.vertx.reactivex.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(io.vertx.reactivex.core.http.WebSocketFrame.newInstance(event));
      }
    });
    return this;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.reactivex.core.net.SocketAddress cached_0;
  private io.vertx.reactivex.core.net.SocketAddress cached_1;

  public static  WebSocket newInstance(io.vertx.core.http.WebSocket arg) {
    return arg != null ? new WebSocket(arg) : null;
  }
}
