/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.net.NetServer.class)
public class NetServer implements io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<NetServer> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the connect stream for this server. The server can only have at most one handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.reactivex.core.net.NetSocket} and passes it to the
   * connect stream .
   * @return the connect stream
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.net.NetSocket> connectStream() { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.net.NetSocket> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.connectStream(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.core.net.NetSocket.__TYPE_ARG);
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.reactivex.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer connectHandler(Handler<io.vertx.reactivex.core.net.NetSocket> handler) { 
    io.vertx.reactivex.core.net.NetServer ret = io.vertx.reactivex.core.net.NetServer.newInstance(delegate.connectHandler(new Handler<io.vertx.core.net.NetSocket>() {
      public void handle(io.vertx.core.net.NetSocket event) {
        handler.handle(io.vertx.reactivex.core.net.NetSocket.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Start listening on the port and host as configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen() { 
    delegate.listen();
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(Handler<AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetServer> rxListen() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(handler);
    });
  }

  /**
   * Start listening on the specified port and host, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * Host <code>0.0.0.0</code> can be specified meaning "listen on all available interfaces".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @param host 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port, String host, Handler<AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetServer> rxListen(int port, String host) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(port, host, handler);
    });
  }

  /**
   * Start listening on the specified port and host "0.0.0.0", ignoring port and host configured in the
   * {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port, Handler<AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetServer> rxListen(int port) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(port, handler);
    });
  }

  /**
   * Start listening on the specified local address, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(io.vertx.reactivex.core.net.SocketAddress localAddress) { 
    delegate.listen(localAddress.getDelegate());
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(io.vertx.reactivex.core.net.SocketAddress localAddress, Handler<AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(localAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.core.net.NetServer> rxListen(io.vertx.reactivex.core.net.SocketAddress localAddress) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listen(localAddress, handler);
    });
  }

  /**
   * Close the server. This will close any currently open connections. The close may not complete until after this
   * method has returned.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @param completionHandler the handler
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }


  public static  NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }
}
