/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * The address of a socket, an inet socket address or a domain socket address.
 * <p/>
 * Use {@link io.vertx.reactivex.core.net.SocketAddress#inetSocketAddress} to create an inet socket address and {@link io.vertx.reactivex.core.net.SocketAddress#domainSocketAddress}
 * to create a domain socket address
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SocketAddress original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.net.SocketAddress.class)
public class SocketAddress {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SocketAddress that = (SocketAddress) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SocketAddress> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SocketAddress((io.vertx.core.net.SocketAddress) obj),
    SocketAddress::getDelegate
  );

  private final io.vertx.core.net.SocketAddress delegate;
  
  public SocketAddress(io.vertx.core.net.SocketAddress delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.net.SocketAddress getDelegate() {
    return delegate;
  }

  /**
   * Create a inet socket address, <code>host</code> must be non <code>null</code> and <code>port</code> must be between <code>0</code>
   * and <code>65536</code>.
   * @param port the address port
   * @param host the address host
   * @return the created socket address
   */
  public static io.vertx.reactivex.core.net.SocketAddress inetSocketAddress(int port, String host) { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(io.vertx.core.net.SocketAddress.inetSocketAddress(port, host));
    return ret;
  }

  /**
   * Create a domain socket address.
   * @param path the address path
   * @return the created socket address
   */
  public static io.vertx.reactivex.core.net.SocketAddress domainSocketAddress(String path) { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance(io.vertx.core.net.SocketAddress.domainSocketAddress(path));
    return ret;
  }

  /**
   * @return the address host or <code>null</code> for a domain socket
   */
  public String host() { 
    String ret = delegate.host();
    return ret;
  }

  /**
   * @return the address port or <code>-1</code> for a domain socket
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  /**
   * @return the address path or <code>null</code> for a inet socket
   */
  public String path() { 
    String ret = delegate.path();
    return ret;
  }


  public static  SocketAddress newInstance(io.vertx.core.net.SocketAddress arg) {
    return arg != null ? new SocketAddress(arg) : null;
  }
}
