/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;

/**
 * An asynchronous exclusive lock which can be obtained from any node in the cluster.
 * <p>
 * When the lock is obtained, no-one else in the cluster can obtain the lock with the same name until the lock
 * is released.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Lock original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.core.shareddata.Lock.class)
public class Lock {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Lock that = (Lock) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Lock> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Lock((io.vertx.core.shareddata.Lock) obj),
    Lock::getDelegate
  );

  private final io.vertx.core.shareddata.Lock delegate;
  
  public Lock(io.vertx.core.shareddata.Lock delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.shareddata.Lock getDelegate() {
    return delegate;
  }

  /**
   * Release the lock. Once the lock is released another will be able to obtain the lock.
   */
  public void release() { 
    delegate.release();
  }


  public static  Lock newInstance(io.vertx.core.shareddata.Lock arg) {
    return arg != null ? new Lock(arg) : null;
  }
}
