/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

/**
 * A response from a fetch request.
 *
 * This class represents a secure response from a Oauth2 fetch call.
 *
 * A fetch is a simplified HTTP response from a protected resource.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.OAuth2Response original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.auth.oauth2.OAuth2Response.class)
public class OAuth2Response {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2Response that = (OAuth2Response) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<OAuth2Response> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new OAuth2Response((io.vertx.ext.auth.oauth2.OAuth2Response) obj),
    OAuth2Response::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.OAuth2Response delegate;
  
  public OAuth2Response(io.vertx.ext.auth.oauth2.OAuth2Response delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.OAuth2Response getDelegate() {
    return delegate;
  }

  /**
   * the returned status code from the HTTP layer.
   * @return HTTP status code
   */
  public int statusCode() { 
    int ret = delegate.statusCode();
    return ret;
  }

  /**
   * The HTTP response headers from the HTTP layer.
   * @return the HTTP headers
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * Looks up a HTTP response header by name, in case where the response is a list of headers,
   * the first one is returned.
   * @param name of the header to look up
   * @return the single value for the header.
   */
  public String getHeader(String name) { 
    String ret = delegate.getHeader(name);
    return ret;
  }

  /**
   * The HTTP response body as a buffer
   * @return a buffer with the HTTP response body
   */
  public io.vertx.reactivex.core.buffer.Buffer body() { 
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance(delegate.body());
    return ret;
  }

  /**
   * The HTTP response body as a JsonObject
   * @return a JsonObject from the HTTP response body
   */
  public JsonObject jsonObject() { 
    JsonObject ret = delegate.jsonObject();
    return ret;
  }

  /**
   * The HTTP response body as a JsonArray
   * @return a JsonArray from the HTTP response body
   */
  public JsonArray jsonArray() { 
    JsonArray ret = delegate.jsonArray();
    return ret;
  }

  /**
   * Helper to analize the response body. The test is performed against the header Content-Type,
   * the content of the body is not analyzed.
   * @param contentType a content type to test, e.g.: application/json
   * @return true if the header matches
   */
  public boolean is(String contentType) { 
    boolean ret = delegate.is(contentType);
    return ret;
  }


  public static  OAuth2Response newInstance(io.vertx.ext.auth.oauth2.OAuth2Response arg) {
    return arg != null ? new OAuth2Response(arg) : null;
  }
}
