/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;

/**
 * Simplified factory to create an {@link io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth} for OpenID Connect.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.class)
public class OpenIDConnectAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenIDConnectAuth that = (OpenIDConnectAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<OpenIDConnectAuth> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new OpenIDConnectAuth((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth) obj),
    OpenIDConnectAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate;
  
  public OpenIDConnectAuth(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
   * configuration options and attempt to load the well known descriptor.
   *
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   * @param handler the instantiated Oauth2 provider instance handler
   */
  public static void discover(io.vertx.reactivex.core.Vertx vertx, OAuth2ClientOptions config, Handler<AsyncResult<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth>> handler) { 
    io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.discover(vertx.getDelegate(), config, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
   * configuration options and attempt to load the well known descriptor.
   *
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth> rxDiscover(io.vertx.reactivex.core.Vertx vertx, OAuth2ClientOptions config) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      discover(vertx, config, handler);
    });
  }


  public static  OpenIDConnectAuth newInstance(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth arg) {
    return arg != null ? new OpenIDConnectAuth(arg) : null;
  }
}
