/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.consul;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import java.util.List;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.CheckList;
import io.vertx.core.Handler;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.EventOptions;

/**
 * A Vert.x service used to interact with Consul.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ConsulClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulClient that = (ConsulClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ConsulClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient) obj),
    ConsulClient::getDelegate
  );

  private final io.vertx.ext.consul.ConsulClient delegate;
  
  public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.consul.ConsulClient getDelegate() {
    return delegate;
  }

  /**
   * Create a Consul client with default options.
   * @param vertx the Vert.x instance
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Consul client.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx, ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @param resultHandler will be provided with the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient agentInfo(Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.agentInfo(resultHandler);
    return this;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public Single<JsonObject> rxAgentInfo() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      agentInfo(handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodes(Handler<AsyncResult<CoordinateList>> resultHandler) { 
    delegate.coordinateNodes(resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @return reference to this, for fluency
   */
  public Single<CoordinateList> rxCoordinateNodes() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      coordinateNodes(handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateNodesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<CoordinateList>> resultHandler) { 
    delegate.coordinateNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<CoordinateList> rxCoordinateNodesWithOptions(BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      coordinateNodesWithOptions(options, handler);
    });
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @param resultHandler will be provided with network coordinates for all Consul servers
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> resultHandler) { 
    delegate.coordinateDatacenters(resultHandler);
    return this;
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @return reference to this, for fluency
   */
  public Single<List<DcCoordinates>> rxCoordinateDatacenters() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      coordinateDatacenters(handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeys(String keyPrefix, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeys(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxGetKeys(String keyPrefix) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getKeys(keyPrefix, handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getKeysWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxGetKeysWithOptions(String keyPrefix, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getKeysWithOptions(keyPrefix, options, handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValue(String key, Handler<AsyncResult<KeyValue>> resultHandler) { 
    delegate.getValue(key, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @return reference to this, for fluency
   */
  public Single<KeyValue> rxGetValue(String key) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValue(key, handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValueWithOptions(String key, BlockingQueryOptions options, Handler<AsyncResult<KeyValue>> resultHandler) { 
    delegate.getValueWithOptions(key, options, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<KeyValue> rxGetValueWithOptions(String key, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValueWithOptions(key, options, handler);
    });
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValue(String key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValue(key, resultHandler);
    return this;
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @return reference to this, for fluency
   */
  public Completable rxDeleteValue(String key) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deleteValue(key, handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValues(String keyPrefix, Handler<AsyncResult<KeyValueList>> resultHandler) { 
    delegate.getValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public Single<KeyValueList> rxGetValues(String keyPrefix) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValues(keyPrefix, handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getValuesWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<KeyValueList>> resultHandler) { 
    delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<KeyValueList> rxGetValuesWithOptions(String keyPrefix, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getValuesWithOptions(keyPrefix, options, handler);
    });
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deleteValues(String keyPrefix, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @return reference to this, for fluency
   */
  public Completable rxDeleteValues(String keyPrefix) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deleteValues(keyPrefix, handler);
    });
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValue(String key, String value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValue(key, value, resultHandler);
    return this;
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @return reference to this, for fluency
   */
  public Single<Boolean> rxPutValue(String key, String value) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      putValue(key, value, handler);
    });
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient putValueWithOptions(String key, String value, KeyValueOptions options, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValueWithOptions(key, value, options, resultHandler);
    return this;
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return reference to this, for fluency
   */
  public Single<Boolean> rxPutValueWithOptions(String key, String value, KeyValueOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      putValueWithOptions(key, value, options, handler);
    });
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @param resultHandler will be provided with result of transaction
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient transaction(TxnRequest request, Handler<AsyncResult<TxnResponse>> resultHandler) { 
    delegate.transaction(request, resultHandler);
    return this;
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @return reference to this, for fluency
   */
  public Single<TxnResponse> rxTransaction(TxnRequest request) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      transaction(request, handler);
    });
  }

  /**
   * Create new Acl token
   * @param token properties of the token
   * @param idHandler will be provided with ID of created token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.createAclToken(token, idHandler);
    return this;
  }

  /**
   * Create new Acl token
   * @param token properties of the token
   * @return reference to this, for fluency
   */
  public Single<String> rxCreateAclToken(AclToken token) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createAclToken(token, handler);
    });
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @param idHandler will be provided with ID of updated
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.updateAclToken(token, idHandler);
    return this;
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @return reference to this, for fluency
   */
  public Single<String> rxUpdateAclToken(AclToken token) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      updateAclToken(token, handler);
    });
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @param idHandler will be provided with ID of cloned token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient cloneAclToken(String id, Handler<AsyncResult<String>> idHandler) { 
    delegate.cloneAclToken(id, idHandler);
    return this;
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @return reference to this, for fluency
   */
  public Single<String> rxCloneAclToken(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      cloneAclToken(id, handler);
    });
  }

  /**
   * Get list of Acl token
   * @param resultHandler will be provided with list of tokens
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listAclTokens(Handler<AsyncResult<List<AclToken>>> resultHandler) { 
    delegate.listAclTokens(resultHandler);
    return this;
  }

  /**
   * Get list of Acl token
   * @return reference to this, for fluency
   */
  public Single<List<AclToken>> rxListAclTokens() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listAclTokens(handler);
    });
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @param tokenHandler will be provided with token
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoAclToken(String id, Handler<AsyncResult<AclToken>> tokenHandler) { 
    delegate.infoAclToken(id, tokenHandler);
    return this;
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  public Single<AclToken> rxInfoAclToken(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      infoAclToken(id, handler);
    });
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient destroyAclToken(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroyAclToken(id, resultHandler);
    return this;
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @return reference to this, for fluency
   */
  public Completable rxDestroyAclToken(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      destroyAclToken(id, handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEvent(String name, Handler<AsyncResult<Event>> resultHandler) { 
    delegate.fireEvent(name, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @return reference to this, for fluency
   */
  public Single<Event> rxFireEvent(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      fireEvent(name, handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient fireEventWithOptions(String name, EventOptions options, Handler<AsyncResult<Event>> resultHandler) { 
    delegate.fireEventWithOptions(name, options, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @return reference to this, for fluency
   */
  public Single<Event> rxFireEventWithOptions(String name, EventOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      fireEventWithOptions(name, options, handler);
    });
  }

  /**
   * Returns the most recent events known by the agent
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEvents(Handler<AsyncResult<EventList>> resultHandler) { 
    delegate.listEvents(resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent
   * @return reference to this, for fluency
   */
  public Single<EventList> rxListEvents() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listEvents(handler);
    });
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listEventsWithOptions(EventListOptions options, Handler<AsyncResult<EventList>> resultHandler) { 
    delegate.listEventsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<EventList> rxListEventsWithOptions(EventListOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listEventsWithOptions(options, handler);
    });
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerService(ServiceOptions serviceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerService(serviceOptions, resultHandler);
    return this;
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @return reference to this, for fluency
   */
  public Completable rxRegisterService(ServiceOptions serviceOptions) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      registerService(serviceOptions, handler);
    });
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient maintenanceService(MaintenanceOptions maintenanceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.maintenanceService(maintenanceOptions, resultHandler);
    return this;
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @return reference to this, for fluency
   */
  public Completable rxMaintenanceService(MaintenanceOptions maintenanceOptions) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      maintenanceService(maintenanceOptions, handler);
    });
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterService(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterService(id, resultHandler);
    return this;
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @return reference to this, for fluency
   */
  public Completable rxDeregisterService(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deregisterService(id, handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodes(String service, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServiceNodes(service, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @return reference to this, for fluency
   */
  public Single<ServiceList> rxCatalogServiceNodes(String service) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodes(service, handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServiceNodesWithOptions(String service, ServiceQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public Single<ServiceList> rxCatalogServiceNodesWithOptions(String service, ServiceQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServiceNodesWithOptions(service, options, handler);
    });
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @param resultHandler will be provided with list of datacenters
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogDatacenters(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.catalogDatacenters(resultHandler);
    return this;
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxCatalogDatacenters() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogDatacenters(handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodes(Handler<AsyncResult<NodeList>> resultHandler) { 
    delegate.catalogNodes(resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @return reference to this, for fluency
   */
  public Single<NodeList> rxCatalogNodes() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodes(handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodesWithOptions(NodeQueryOptions options, Handler<AsyncResult<NodeList>> resultHandler) { 
    delegate.catalogNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @return reference to this, for fluency
   */
  public Single<NodeList> rxCatalogNodesWithOptions(NodeQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodesWithOptions(options, handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecks(String service, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthChecks(service, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @return reference to this, for fluency
   */
  public Single<CheckList> rxHealthChecks(String service) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthChecks(service, handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthChecksWithOptions(String service, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthChecksWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public Single<CheckList> rxHealthChecksWithOptions(String service, CheckQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthChecksWithOptions(service, options, handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthState(HealthState healthState, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthState(healthState, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @return reference to this, for fluency
   */
  public Single<CheckList> rxHealthState(HealthState healthState) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthState(healthState, handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthStateWithOptions(HealthState healthState, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthStateWithOptions(healthState, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @return reference to this, for fluency
   */
  public Single<CheckList> rxHealthStateWithOptions(HealthState healthState, CheckQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthStateWithOptions(healthState, options, handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodes(String service, boolean passing, Handler<AsyncResult<ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodes(service, passing, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return reference to this, for fluency
   */
  public Single<ServiceEntryList> rxHealthServiceNodes(String service, boolean passing) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthServiceNodes(service, passing, handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient healthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options, Handler<AsyncResult<ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return reference to this, for fluency
   */
  public Single<ServiceEntryList> rxHealthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      healthServiceNodesWithOptions(service, passing, options, handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServices(Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServices(resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * @return reference to this, for fluency
   */
  public Single<ServiceList> rxCatalogServices() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServices(handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogServicesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServicesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<ServiceList> rxCatalogServicesWithOptions(BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogServicesWithOptions(options, handler);
    });
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServices(String node, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogNodeServices(node, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @return reference to this, for fluency
   */
  public Single<ServiceList> rxCatalogNodeServices(String node) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodeServices(node, handler);
    });
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient catalogNodeServicesWithOptions(String node, BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<ServiceList> rxCatalogNodeServicesWithOptions(String node, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      catalogNodeServicesWithOptions(node, options, handler);
    });
  }

  /**
   * Returns list of services registered with the local agent.
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localServices(Handler<AsyncResult<List<Service>>> resultHandler) { 
    delegate.localServices(resultHandler);
    return this;
  }

  /**
   * Returns list of services registered with the local agent.
   * @return reference to this, for fluency
   */
  public Single<List<Service>> rxLocalServices() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      localServices(handler);
    });
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient localChecks(Handler<AsyncResult<List<Check>>> resultHandler) { 
    delegate.localChecks(resultHandler);
    return this;
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @return reference to this, for fluency
   */
  public Single<List<Check>> rxLocalChecks() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      localChecks(handler);
    });
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient registerCheck(CheckOptions checkOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerCheck(checkOptions, resultHandler);
    return this;
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @return reference to this, for fluency
   */
  public Completable rxRegisterCheck(CheckOptions checkOptions) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      registerCheck(checkOptions, handler);
    });
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deregisterCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxDeregisterCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deregisterCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxPassCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      passCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient passCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxPassCheckWithNote(String checkId, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      passCheckWithNote(checkId, note, handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxWarnCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      warnCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient warnCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxWarnCheckWithNote(String checkId, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      warnCheckWithNote(checkId, note, handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return reference to this, for fluency
   */
  public Completable rxFailCheck(String checkId) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      failCheck(checkId, handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient failCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxFailCheckWithNote(String checkId, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      failCheckWithNote(checkId, note, handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheck(String checkId, CheckStatus status, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheck(checkId, status, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @return reference to this, for fluency
   */
  public Completable rxUpdateCheck(String checkId, CheckStatus status) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updateCheck(checkId, status, handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updateCheckWithNote(String checkId, CheckStatus status, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheckWithNote(checkId, status, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return reference to this, for fluency
   */
  public Completable rxUpdateCheckWithNote(String checkId, CheckStatus status, String note) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updateCheckWithNote(checkId, status, note, handler);
    });
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @param resultHandler will be provided with address of cluster leader
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient leaderStatus(Handler<AsyncResult<String>> resultHandler) { 
    delegate.leaderStatus(resultHandler);
    return this;
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @return reference to this, for fluency
   */
  public Single<String> rxLeaderStatus() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      leaderStatus(handler);
    });
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @param resultHandler will be provided with list of peers
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient peersStatus(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.peersStatus(resultHandler);
    return this;
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @return reference to this, for fluency
   */
  public Single<List<String>> rxPeersStatus() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      peersStatus(handler);
    });
  }

  /**
   * Initialize a new session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSession(Handler<AsyncResult<String>> idHandler) { 
    delegate.createSession(idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @return reference to this, for fluency
   */
  public Single<String> rxCreateSession() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createSession(handler);
    });
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createSessionWithOptions(SessionOptions options, Handler<AsyncResult<String>> idHandler) { 
    delegate.createSessionWithOptions(options, idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @return reference to this, for fluency
   */
  public Single<String> rxCreateSessionWithOptions(SessionOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createSessionWithOptions(options, handler);
    });
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSession(String id, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.infoSession(id, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @return reference to this, for fluency
   */
  public Single<Session> rxInfoSession(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      infoSession(id, handler);
    });
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient infoSessionWithOptions(String id, BlockingQueryOptions options, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.infoSessionWithOptions(id, options, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<Session> rxInfoSessionWithOptions(String id, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      infoSessionWithOptions(id, options, handler);
    });
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @param resultHandler will be provided with info of renewed session
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient renewSession(String id, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.renewSession(id, resultHandler);
    return this;
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @return reference to this, for fluency
   */
  public Single<Session> rxRenewSession(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      renewSession(id, handler);
    });
  }

  /**
   * Returns the active sessions
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessions(Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listSessions(resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * @return reference to this, for fluency
   */
  public Single<SessionList> rxListSessions() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listSessions(handler);
    });
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listSessionsWithOptions(BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listSessionsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<SessionList> rxListSessionsWithOptions(BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listSessionsWithOptions(options, handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessions(String nodeId, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listNodeSessions(nodeId, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @return reference to this, for fluency
   */
  public Single<SessionList> rxListNodeSessions(String nodeId) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listNodeSessions(nodeId, handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient listNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return reference to this, for fluency
   */
  public Single<SessionList> rxListNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listNodeSessionsWithOptions(nodeId, options, handler);
    });
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient destroySession(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroySession(id, resultHandler);
    return this;
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @return reference to this, for fluency
   */
  public Completable rxDestroySession(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      destroySession(id, handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be provided with id of created prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient createPreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<String>> resultHandler) { 
    delegate.createPreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public Single<String> rxCreatePreparedQuery(PreparedQueryDefinition definition) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createPreparedQuery(definition, handler);
    });
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @param resultHandler will be provided with definition of the prepare query
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getPreparedQuery(String id, Handler<AsyncResult<PreparedQueryDefinition>> resultHandler) { 
    delegate.getPreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @return reference to this, for fluency
   */
  public Single<PreparedQueryDefinition> rxGetPreparedQuery(String id) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getPreparedQuery(id, handler);
    });
  }

  /**
   * Returns a list of all prepared queries.
   * @param resultHandler will be provided with list of definitions of the all prepare queries
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> resultHandler) { 
    delegate.getAllPreparedQueries(resultHandler);
    return this;
  }

  /**
   * Returns a list of all prepared queries.
   * @return reference to this, for fluency
   */
  public Single<List<PreparedQueryDefinition>> rxGetAllPreparedQueries() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getAllPreparedQueries(handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient updatePreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updatePreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return reference to this, for fluency
   */
  public Completable rxUpdatePreparedQuery(PreparedQueryDefinition definition) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updatePreparedQuery(definition, handler);
    });
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient deletePreparedQuery(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deletePreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @return reference to this, for fluency
   */
  public Completable rxDeletePreparedQuery(String id) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      deletePreparedQuery(id, handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQuery(String query, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQuery(query, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return reference to this, for fluency
   */
  public Single<PreparedQueryExecuteResponse> rxExecutePreparedQuery(String query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executePreparedQuery(query, handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.ConsulClient executePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQueryWithOptions(query, options, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return reference to this, for fluency
   */
  public Single<PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      executePreparedQueryWithOptions(query, options, handler);
    });
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }


  public static  ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
    return arg != null ? new ConsulClient(arg) : null;
  }
}
