/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.consul;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.NodeList;
import io.vertx.core.Handler;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.EventList;

/**
 * Watches are a way of specifying a view of data (e.g. list of nodes, KV pairs, health checks)
 * which is monitored for updates. When an update is detected, an <code>Handler</code> with <code>AsyncResult</code> is invoked.
 * As an example, you could watch the status of health checks and notify when a check is critical.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.Watch original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.consul.Watch.class)
public class Watch<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Watch that = (Watch) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Watch> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Watch((io.vertx.ext.consul.Watch) obj),
    Watch::getDelegate
  );

  private final io.vertx.ext.consul.Watch<T> delegate;
  public final io.vertx.lang.rx.TypeArg<T> __typeArg_0;
  
  public Watch(io.vertx.ext.consul.Watch delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();  }

  public Watch(io.vertx.ext.consul.Watch delegate, io.vertx.lang.rx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.consul.Watch getDelegate() {
    return delegate;
  }

  /**
   * Creates <code>Watch</code> to monitoring a specific key in the KV store.
   * The underlying Consul client will be created with default options.
   * This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
   * @param key the key
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<KeyValue> key(String key, io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.Watch<KeyValue> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.key(key, vertx.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring a specific key in the KV store.
   * This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
   * @param key the key
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<KeyValue> key(String key, io.vertx.reactivex.core.Vertx vertx, ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.Watch<KeyValue> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.key(key, vertx.getDelegate(), options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring a prefix of keys in the KV store.
   * The underlying Consul client will be created with default options.
   * This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
   * @param keyPrefix the key
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<KeyValueList> keyPrefix(String keyPrefix, io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.Watch<KeyValueList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.keyPrefix(keyPrefix, vertx.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring a prefix of keys in the KV store.
   * This maps to the <a href="https://www.consul.io/api/kv.html">/v1/kv/</a> API internally.
   * @param keyPrefix the key
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<KeyValueList> keyPrefix(String keyPrefix, io.vertx.reactivex.core.Vertx vertx, ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.Watch<KeyValueList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.keyPrefix(keyPrefix, vertx.getDelegate(), options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the list of available services.
   * The underlying Consul client will be created with default options.
   * This maps to the <a href="https://www.consul.io/docs/agent/http/catalog.html#catalog_services">/v1/catalog/services</a> API internally.
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<ServiceList> services(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.Watch<ServiceList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.services(vertx.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the list of available services.
   * This maps to the <a href="https://www.consul.io/docs/agent/http/catalog.html#catalog_services">/v1/catalog/services</a> API internally.
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<ServiceList> services(io.vertx.reactivex.core.Vertx vertx, ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.Watch<ServiceList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.services(vertx.getDelegate(), options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the nodes providing the service.
   * The underlying Consul client will be created with default options.
   * This maps to the <a href="https://www.consul.io/docs/agent/http/health.html#health_service">/v1/health/service/&lt;service&gt;</a> API internally.
   * @param service the service name
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<ServiceEntryList> service(String service, io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.Watch<ServiceEntryList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.service(service, vertx.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the nodes providing the service.
   * This maps to the <a href="https://www.consul.io/docs/agent/http/health.html#health_service">/v1/health/service/&lt;service&gt;</a> API internally.
   * @param service the service name
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<ServiceEntryList> service(String service, io.vertx.reactivex.core.Vertx vertx, ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.Watch<ServiceEntryList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.service(service, vertx.getDelegate(), options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the custom user events.
   * The underlying Consul client will be created with default options.
   * This maps to the <a href="https://www.consul.io/docs/agent/http/event.html#event_list">/v1/event/list</a> API internally.
   * @param event the event name
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<EventList> events(String event, io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.Watch<EventList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.events(event, vertx.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the custom user events.
   * This maps to the <a href="https://www.consul.io/docs/agent/http/event.html#event_list">/v1/event/list</a> API internally.
   * @param event the event name
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<EventList> events(String event, io.vertx.reactivex.core.Vertx vertx, ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.Watch<EventList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.events(event, vertx.getDelegate(), options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the list of available nodes.
   * The underlying Consul client will be created with default options.
   * This maps to the <a href="https://www.consul.io/api/catalog.html#list-nodes">/v1/catalog/nodes</a> API internally.
   * @param vertx the <code>Vertx</code> instance
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<NodeList> nodes(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.Watch<NodeList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.nodes(vertx.getDelegate()), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Creates <code>Watch</code> to monitoring the list of available nodes.
   * This maps to the <a href="https://www.consul.io/api/catalog.html#list-nodes">/v1/catalog/nodes</a> API internally.
   * @param vertx the <code>Vertx</code> instance
   * @param options the options to create underlying Consul client
   * @return the <code>Watch</code> instance
   */
  public static io.vertx.reactivex.ext.consul.Watch<NodeList> nodes(io.vertx.reactivex.core.Vertx vertx, ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.Watch<NodeList> ret = io.vertx.reactivex.ext.consul.Watch.newInstance(io.vertx.ext.consul.Watch.nodes(vertx.getDelegate(), options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Set the result handler. As data is changed, the handler will be called with the result.
   * @param handler the result handler
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.Watch<T> setHandler(Handler<io.vertx.reactivex.ext.consul.WatchResult<T>> handler) { 
    delegate.setHandler(new Handler<io.vertx.ext.consul.WatchResult<T>>() {
      public void handle(io.vertx.ext.consul.WatchResult<T> event) {
        handler.handle(io.vertx.reactivex.ext.consul.WatchResult.newInstance(event, __typeArg_0));
      }
    });
    return this;
  }

  /**
   * Start this <code>Watch</code>
   * @return reference to this, for fluency
   */
  public io.vertx.reactivex.ext.consul.Watch<T> start() { 
    delegate.start();
    return this;
  }

  /**
   * Stop the watch and release its resources
   */
  public void stop() { 
    delegate.stop();
  }


  public static <T>Watch<T> newInstance(io.vertx.ext.consul.Watch arg) {
    return arg != null ? new Watch<T>(arg) : null;
  }

  public static <T>Watch<T> newInstance(io.vertx.ext.consul.Watch arg, io.vertx.lang.rx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Watch<T>(arg, __typeArg_T) : null;
  }
}
