/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;

/**
 * A Vert.x service used to interact with MongoDB server instances.
 * <p>
 * Some of the operations might change <i>_id</i> field of passed  document.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.mongo.MongoClient.class)
public class MongoClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoClient that = (MongoClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MongoClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MongoClient((io.vertx.ext.mongo.MongoClient) obj),
    MongoClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoClient delegate;
  
  public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.mongo.MongoClient getDelegate() {
    return delegate;
  }

  /**
   * @param vertx 
   * @param config 
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.mongo.MongoClient createNonShared(io.vertx.reactivex.core.Vertx vertx, JsonObject config) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createNonShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a Mongo client which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient create(io.vertx.reactivex.core.Vertx vertx, JsonObject config) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a Mongo client which shares its data source with any other Mongo clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, JsonObject config, String dataSourceName) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.mongo.MongoClient#createShared} but with the default data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, JsonObject config) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.save(collection, document, resultHandler);
    return this;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public Maybe<String> rxSave(String collection, JsonObject document) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      save(collection, document, handler);
    });
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.saveWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public Maybe<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      saveWithOptions(collection, document, writeOption, handler);
    });
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insert(collection, document, resultHandler);
    return this;
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return 
   */
  public Maybe<String> rxInsert(String collection, JsonObject document) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      insert(collection, document, handler);
    });
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @param resultHandler result handler will be provided with the id if document didn't already have one
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insertWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return 
   */
  public Maybe<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      insertWithOptions(collection, document, writeOption, handler);
    });
  }

  /**
   * Update matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.update(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  @Deprecated()
  public Completable rxUpdate(String collection, JsonObject query, JsonObject update) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      update(collection, query, update, handler);
    });
  }

  /**
   * Update matching documents in the specified collection and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public Maybe<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      updateCollection(collection, query, update, handler);
    });
  }

  /**
   * Update matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return 
   */
  @Deprecated()
  public Completable rxUpdateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      updateWithOptions(collection, query, update, options, handler);
    });
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return 
   */
  public Maybe<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      updateCollectionWithOptions(collection, query, update, options, handler);
    });
  }

  /**
   * Replace matching documents in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>replace</i> parameter
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replace(collection, query, replace, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>replace</i> parameter
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return 
   */
  @Deprecated()
  public Completable rxReplace(String collection, JsonObject query, JsonObject replace) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      replace(collection, query, replace, handler);
    });
  }

  /**
   * Replace matching documents in the specified collection and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocuments(collection, query, replace, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return 
   */
  public Maybe<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      replaceDocuments(collection, query, replace, handler);
    });
  }

  /**
   * Replace matching documents in the specified collection, specifying options
   * <p>
   * This operation might change <i>_id</i> field of <i>replace</i> parameter
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replaceWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection, specifying options
   * <p>
   * This operation might change <i>_id</i> field of <i>replace</i> parameter
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return 
   */
  @Deprecated()
  public Completable rxReplaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      replaceWithOptions(collection, query, replace, options, handler);
    });
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with MongoClientUpdateResult result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return 
   */
  public Maybe<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      replaceDocumentsWithOptions(collection, query, replace, options, handler);
    });
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWrite(collection, operations, resultHandler);
    return this;
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @return 
   */
  public Maybe<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bulkWrite(collection, operations, handler);
    });
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @param resultHandler will be called with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
    return this;
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return 
   */
  public Maybe<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      bulkWriteWithOptions(collection, operations, bulkWriteOptions, handler);
    });
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be provided with list of documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.find(collection, query, resultHandler);
    return this;
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public Single<List<JsonObject>> rxFind(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      find(collection, query, handler);
    });
  }

  /**
   * Find matching documents in the specified collection.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @return a  emitting found documents
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonObject> findBatch(String collection, JsonObject query) { 
    io.vertx.reactivex.core.streams.ReadStream<JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.findBatch(collection, query), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @param resultHandler will be provided with list of documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.findWithOptions(collection, query, options, resultHandler);
    return this;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return 
   */
  public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      findWithOptions(collection, query, options, handler);
    });
  }

  /**
   * Find matching documents in the specified collection, specifying options.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return a  emitting found documents
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.findBatchWithOptions(collection, query, options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOne(collection, query, fields, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return 
   */
  public Maybe<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOne(collection, query, fields, handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdate(collection, query, update, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return 
   */
  public Maybe<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndUpdate(collection, query, update, handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public Maybe<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplace(collection, query, replace, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return 
   */
  public Maybe<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndReplace(collection, query, replace, handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @param resultHandler will be provided with the document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return 
   */
  public Maybe<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param resultHandler will be provided with the deleted document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDelete(collection, query, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @return 
   */
  public Maybe<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndDelete(collection, query, handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @param resultHandler will be provided with the deleted document, if any
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
    return this;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return 
   */
  public Maybe<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      findOneAndDeleteWithOptions(collection, query, findOptions, handler);
    });
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be provided with the number of matching documents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.count(collection, query, resultHandler);
    return this;
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public Single<Long> rxCount(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      count(collection, query, handler);
    });
  }

  /**
   * Remove matching documents from a collection
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.remove(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  @Deprecated()
  public Completable rxRemove(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      remove(collection, query, handler);
    });
  }

  /**
   * Remove matching documents from a collection and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match documents
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocuments(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match documents
   * @return 
   */
  public Maybe<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocuments(collection, query, handler);
    });
  }

  /**
   * Remove matching documents from a collection with the specified write option
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection with the specified write option
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return 
   */
  @Deprecated()
  public Completable rxRemoveWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      removeWithOptions(collection, query, writeOption, handler);
    });
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return 
   */
  public Maybe<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocumentsWithOptions(collection, query, writeOption, handler);
    });
  }

  /**
   * Remove a single matching document from a collection
   * @param collection the collection
   * @param query query used to match document
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOne(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection
   * @param collection the collection
   * @param query query used to match document
   * @return 
   */
  @Deprecated()
  public Completable rxRemoveOne(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      removeOne(collection, query, handler);
    });
  }

  /**
   * Remove a single matching document from a collection and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match document
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocument(collection, query, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match document
   * @return 
   */
  public Maybe<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocument(collection, query, handler);
    });
  }

  /**
   * Remove a single matching document from a collection with the specified write option
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @param resultHandler will be called when complete
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.mongo.MongoClient removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOneWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection with the specified write option
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return 
   */
  @Deprecated()
  public Completable rxRemoveOneWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      removeOneWithOptions(collection, query, writeOption, handler);
    });
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with MongoClientDeleteResult result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return 
   */
  public Maybe<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      removeDocumentWithOptions(collection, query, writeOption, handler);
    });
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createCollection(collectionName, resultHandler);
    return this;
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @return 
   */
  public Completable rxCreateCollection(String collectionName) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createCollection(collectionName, handler);
    });
  }

  /**
   * Get a list of all collections in the database.
   * @param resultHandler will be called with a list of collections.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient getCollections(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getCollections(resultHandler);
    return this;
  }

  /**
   * Get a list of all collections in the database.
   * @return 
   */
  public Single<List<String>> rxGetCollections() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getCollections(handler);
    });
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropCollection(collection, resultHandler);
    return this;
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @return 
   */
  public Completable rxDropCollection(String collection) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      dropCollection(collection, handler);
    });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndex(collection, key, resultHandler);
    return this;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return 
   */
  public Completable rxCreateIndex(String collection, JsonObject key) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createIndex(collection, key, handler);
    });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndexWithOptions(collection, key, options, resultHandler);
    return this;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return 
   */
  public Completable rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      createIndexWithOptions(collection, key, options, handler);
    });
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.listIndexes(collection, resultHandler);
    return this;
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @return 
   */
  public Single<JsonArray> rxListIndexes(String collection) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      listIndexes(collection, handler);
    });
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @param resultHandler will be called when complete
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropIndex(collection, indexName, resultHandler);
    return this;
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return 
   */
  public Completable rxDropIndex(String collection, String indexName) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      dropIndex(collection, indexName, handler);
    });
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @param resultHandler will be called with the result.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.runCommand(commandName, command, resultHandler);
    return this;
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @return 
   */
  public Maybe<JsonObject> rxRunCommand(String commandName, JsonObject command) { 
    return io.vertx.reactivex.impl.AsyncResultMaybe.toMaybe(handler -> {
      runCommand(commandName, command, handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return 
   */
  public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      distinct(collection, fieldName, resultClassname, handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param resultHandler will be provided with array of values.
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
    return this;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return 
   */
  public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) { 
    io.vertx.reactivex.core.streams.ReadStream<JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.distinctBatch(collection, fieldName, resultClassname), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) { 
    io.vertx.reactivex.core.streams.ReadStream<JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) { 
    io.vertx.reactivex.core.streams.ReadStream<JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command with default {@link io.vertx.ext.mongo.AggregateOptions}.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) { 
    io.vertx.reactivex.core.streams.ReadStream<JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.aggregate(collection, pipeline), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @param options options to configure the aggregation command
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance(delegate.aggregateWithOptions(collection, pipeline, options), io.vertx.lang.rx.TypeArg.unknown());
    return ret;
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_POOL_NAME;
  /**
   * The name of the default database
   */
  public static final String DEFAULT_DB_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_DB_NAME;

  public static  MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
    return arg != null ? new MongoClient(arg) : null;
  }
}
