/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import java.util.function.Function;

/**
 * An interactive session between a consumer and a shell.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.Shell original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.Shell.class)
public class Shell {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Shell that = (Shell) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Shell> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Shell((io.vertx.ext.shell.Shell) obj),
    Shell::getDelegate
  );

  private final io.vertx.ext.shell.Shell delegate;
  
  public Shell(io.vertx.ext.shell.Shell delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.shell.Shell getDelegate() {
    return delegate;
  }

  /**
   * Create a job, the created job should then be executed with the {@link io.vertx.reactivex.ext.shell.system.Job#run} method.
   * @param line the command line creating this job
   * @return the created job
   */
  public io.vertx.reactivex.ext.shell.system.Job createJob(List<io.vertx.reactivex.ext.shell.cli.CliToken> line) { 
    io.vertx.reactivex.ext.shell.system.Job ret = io.vertx.reactivex.ext.shell.system.Job.newInstance(delegate.createJob(line.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * See {@link io.vertx.reactivex.ext.shell.Shell#createJob}
   * @param line 
   * @return 
   */
  public io.vertx.reactivex.ext.shell.system.Job createJob(String line) { 
    io.vertx.reactivex.ext.shell.system.Job ret = io.vertx.reactivex.ext.shell.system.Job.newInstance(delegate.createJob(line));
    return ret;
  }

  /**
   * @return the shell's job controller
   */
  public io.vertx.reactivex.ext.shell.system.JobController jobController() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.ext.shell.system.JobController ret = io.vertx.reactivex.ext.shell.system.JobController.newInstance(delegate.jobController());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the current shell session
   */
  public io.vertx.reactivex.ext.shell.session.Session session() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.ext.shell.session.Session ret = io.vertx.reactivex.ext.shell.session.Session.newInstance(delegate.session());
    cached_1 = ret;
    return ret;
  }

  /**
   * Set a new prompt in this session.
   * @param prompt the new prompt will be calculated when it's needed.
   */
  public void setPrompt(Function<io.vertx.reactivex.ext.shell.session.Session, String> prompt) { 
    delegate.setPrompt(new java.util.function.Function<io.vertx.ext.shell.session.Session,java.lang.String>() {
      public java.lang.String apply(io.vertx.ext.shell.session.Session arg) {
        String ret = prompt.apply(io.vertx.reactivex.ext.shell.session.Session.newInstance(arg));
        return ret;
      }
    });
  }

  /**
   * Close the shell.
   */
  public void close() { 
    delegate.close();
  }

  private io.vertx.reactivex.ext.shell.system.JobController cached_0;
  private io.vertx.reactivex.ext.shell.session.Session cached_1;

  public static  Shell newInstance(io.vertx.ext.shell.Shell arg) {
    return arg != null ? new Shell(arg) : null;
  }
}
