/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.cli;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;

/**
 * A parsed token in the command line interface.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.cli.CliToken original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.cli.CliToken.class)
public class CliToken {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CliToken that = (CliToken) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CliToken> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CliToken((io.vertx.ext.shell.cli.CliToken) obj),
    CliToken::getDelegate
  );

  private final io.vertx.ext.shell.cli.CliToken delegate;
  
  public CliToken(io.vertx.ext.shell.cli.CliToken delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.shell.cli.CliToken getDelegate() {
    return delegate;
  }

  /**
   * Create a text token.
   * @param text the text
   * @return the token
   */
  public static io.vertx.reactivex.ext.shell.cli.CliToken createText(String text) { 
    io.vertx.reactivex.ext.shell.cli.CliToken ret = io.vertx.reactivex.ext.shell.cli.CliToken.newInstance(io.vertx.ext.shell.cli.CliToken.createText(text));
    return ret;
  }

  /**
   * Create a new blank token.
   * @param blank the blank value
   * @return the token
   */
  public static io.vertx.reactivex.ext.shell.cli.CliToken createBlank(String blank) { 
    io.vertx.reactivex.ext.shell.cli.CliToken ret = io.vertx.reactivex.ext.shell.cli.CliToken.newInstance(io.vertx.ext.shell.cli.CliToken.createBlank(blank));
    return ret;
  }

  /**
   * @return the token value
   */
  public String value() { 
    String ret = delegate.value();
    return ret;
  }

  /**
   * @return the raw token value, that may contain unescaped chars, for instance 
   */
  public String raw() { 
    String ret = delegate.raw();
    return ret;
  }

  /**
   * @return true when it's a text token
   */
  public boolean isText() { 
    boolean ret = delegate.isText();
    return ret;
  }

  /**
   * @return true when it's a blank token
   */
  public boolean isBlank() { 
    boolean ret = delegate.isBlank();
    return ret;
  }

  /**
   * Tokenize the string argument and return a list of tokens.
   * @param s the tokenized string
   * @return the tokens
   */
  public static List<io.vertx.reactivex.ext.shell.cli.CliToken> tokenize(String s) { 
    List<io.vertx.reactivex.ext.shell.cli.CliToken> ret = io.vertx.ext.shell.cli.CliToken.tokenize(s).stream().map(elt -> io.vertx.reactivex.ext.shell.cli.CliToken.newInstance(elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }


  public static  CliToken newInstance(io.vertx.ext.shell.cli.CliToken arg) {
    return arg != null ? new CliToken(arg) : null;
  }
}
