/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.cli;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;

/**
 * The completion object
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.cli.Completion original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.cli.Completion.class)
public class Completion {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Completion that = (Completion) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Completion> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Completion((io.vertx.ext.shell.cli.Completion) obj),
    Completion::getDelegate
  );

  private final io.vertx.ext.shell.cli.Completion delegate;
  
  public Completion(io.vertx.ext.shell.cli.Completion delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.shell.cli.Completion getDelegate() {
    return delegate;
  }

  /**
   * @return the current Vert.x instance
   */
  public io.vertx.reactivex.core.Vertx vertx() { 
    io.vertx.reactivex.core.Vertx ret = io.vertx.reactivex.core.Vertx.newInstance(delegate.vertx());
    return ret;
  }

  /**
   * @return the shell current session, useful for accessing data like the current path for file completion, etc...
   */
  public io.vertx.reactivex.ext.shell.session.Session session() { 
    io.vertx.reactivex.ext.shell.session.Session ret = io.vertx.reactivex.ext.shell.session.Session.newInstance(delegate.session());
    return ret;
  }

  /**
   * @return the current line being completed in raw format, i.e without any char escape performed
   */
  public String rawLine() { 
    String ret = delegate.rawLine();
    return ret;
  }

  /**
   * @return the current line being completed as preparsed tokens
   */
  public List<io.vertx.reactivex.ext.shell.cli.CliToken> lineTokens() { 
    List<io.vertx.reactivex.ext.shell.cli.CliToken> ret = delegate.lineTokens().stream().map(elt -> io.vertx.reactivex.ext.shell.cli.CliToken.newInstance(elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * End the completion with a list of candidates, these candidates will be displayed by the shell on the console.
   * @param candidates the candidates
   */
  public void complete(List<String> candidates) { 
    delegate.complete(candidates);
  }

  /**
   * End the completion with a value that will be inserted to complete the line.
   * @param value the value to complete with
   * @param terminal true if the value is terminal, i.e can be further completed
   */
  public void complete(String value, boolean terminal) { 
    delegate.complete(value, terminal);
  }


  public static  Completion newInstance(io.vertx.ext.shell.cli.Completion arg) {
    return arg != null ? new Completion(arg) : null;
  }
}
