/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.command;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;

/**
 * A resolver for commands, so the shell can discover commands.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandResolver original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.command.CommandResolver.class)
public class CommandResolver {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandResolver that = (CommandResolver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<CommandResolver> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new CommandResolver((io.vertx.ext.shell.command.CommandResolver) obj),
    CommandResolver::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandResolver delegate;
  
  public CommandResolver(io.vertx.ext.shell.command.CommandResolver delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.shell.command.CommandResolver getDelegate() {
    return delegate;
  }

  /**
   * @param vertx 
   * @return the base commands of Vert.x Shell.
   */
  public static io.vertx.reactivex.ext.shell.command.CommandResolver baseCommands(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.shell.command.CommandResolver ret = io.vertx.reactivex.ext.shell.command.CommandResolver.newInstance(io.vertx.ext.shell.command.CommandResolver.baseCommands(vertx.getDelegate()));
    return ret;
  }

  /**
   * @return the current commands
   */
  public List<io.vertx.reactivex.ext.shell.command.Command> commands() { 
    List<io.vertx.reactivex.ext.shell.command.Command> ret = delegate.commands().stream().map(elt -> io.vertx.reactivex.ext.shell.command.Command.newInstance(elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * Returns a single command by its name.
   * @param name the command name
   * @return the commad or null
   */
  public io.vertx.reactivex.ext.shell.command.Command getCommand(String name) { 
    io.vertx.reactivex.ext.shell.command.Command ret = io.vertx.reactivex.ext.shell.command.Command.newInstance(delegate.getCommand(name));
    return ret;
  }


  public static  CommandResolver newInstance(io.vertx.ext.shell.command.CommandResolver arg) {
    return arg != null ? new CommandResolver(arg) : null;
  }
}
