/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.term;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 * The terminal.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.Term original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.shell.term.Term.class)
public class Term extends io.vertx.reactivex.ext.shell.term.Tty {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Term that = (Term) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Term> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Term((io.vertx.ext.shell.term.Term) obj),
    Term::getDelegate
  );

  private final io.vertx.ext.shell.term.Term delegate;
  
  public Term(io.vertx.ext.shell.term.Term delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.shell.term.Term getDelegate() {
    return delegate;
  }

  public io.vertx.reactivex.ext.shell.term.Term resizehandler(Handler<Void> handler) { 
    delegate.resizehandler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.shell.term.Term stdinHandler(Handler<String> handler) { 
    delegate.stdinHandler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.shell.term.Term write(String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * @return the last time this term received input
   */
  public long lastAccessedTime() { 
    long ret = delegate.lastAccessedTime();
    return ret;
  }

  /**
   * Echo some text in the terminal, escaped if necessary.<p/>
   * @param text the text to echo
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.term.Term echo(String text) { 
    delegate.echo(text);
    return this;
  }

  /**
   * Associate the term with a session.
   * @param session the session to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.term.Term setSession(io.vertx.reactivex.ext.shell.session.Session session) { 
    io.vertx.reactivex.ext.shell.term.Term ret = io.vertx.reactivex.ext.shell.term.Term.newInstance(delegate.setSession(session.getDelegate()));
    return ret;
  }

  /**
   * Set an interrupt signal handler on the term.
   * @param handler the interrupt handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.term.Term interruptHandler(io.vertx.reactivex.ext.shell.term.SignalHandler handler) { 
    delegate.interruptHandler(handler.getDelegate());
    return this;
  }

  /**
   * Set a suspend signal handler on the term.
   * @param handler the suspend handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.term.Term suspendHandler(io.vertx.reactivex.ext.shell.term.SignalHandler handler) { 
    delegate.suspendHandler(handler.getDelegate());
    return this;
  }

  /**
   * Prompt the user a line of text.
   * @param prompt the displayed prompt
   * @param lineHandler the line handler called with the line
   */
  public void readline(String prompt, Handler<String> lineHandler) { 
    delegate.readline(prompt, lineHandler);
  }

  /**
   * Prompt the user a line of text, providing a completion handler to handle user's completion.
   * @param prompt the displayed prompt
   * @param lineHandler the line handler called with the line
   * @param completionHandler the completion handler
   */
  public void readline(String prompt, Handler<String> lineHandler, Handler<io.vertx.reactivex.ext.shell.cli.Completion> completionHandler) { 
    delegate.readline(prompt, lineHandler, new Handler<io.vertx.ext.shell.cli.Completion>() {
      public void handle(io.vertx.ext.shell.cli.Completion event) {
        completionHandler.handle(io.vertx.reactivex.ext.shell.cli.Completion.newInstance(event));
      }
    });
  }

  /**
   * Set a handler that will be called when the terminal is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.shell.term.Term closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Close the connection to terminal.
   */
  public void close() { 
    delegate.close();
  }


  public static  Term newInstance(io.vertx.ext.shell.term.Term arg) {
    return arg != null ? new Term(arg) : null;
  }
}
