/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.validation;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import java.util.Map;

/**
 * Interface that define methods for deserialization of array and objects
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.validation.ContainerDeserializer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.api.validation.ContainerDeserializer.class)
public class ContainerDeserializer {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ContainerDeserializer that = (ContainerDeserializer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ContainerDeserializer> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ContainerDeserializer((io.vertx.ext.web.api.validation.ContainerDeserializer) obj),
    ContainerDeserializer::getDelegate
  );

  private final io.vertx.ext.web.api.validation.ContainerDeserializer delegate;
  
  public ContainerDeserializer(io.vertx.ext.web.api.validation.ContainerDeserializer delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.api.validation.ContainerDeserializer getDelegate() {
    return delegate;
  }

  public List<String> deserializeArray(String serialized) { 
    List<String> ret = delegate.deserializeArray(serialized);
    return ret;
  }

  public Map<String, String> deserializeObject(String serialized) { 
    Map<String, String> ret = delegate.deserializeObject(serialized);
    return ret;
  }


  public static  ContainerDeserializer newInstance(io.vertx.ext.web.api.validation.ContainerDeserializer arg) {
    return arg != null ? new ContainerDeserializer(arg) : null;
  }
}
