/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.function.Function;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A client-side HTTP request.
 * <p>
 * Instances are created by an {@link io.vertx.reactivex.ext.web.client.WebClient} instance, via one of the methods corresponding to the specific
 * HTTP methods such as {@link io.vertx.reactivex.ext.web.client.WebClient#get}, etc...
 * <p>
 * The request shall be configured prior sending, the request is immutable and when a mutator method
 * is called, a new request is returned allowing to expose the request in a public API and apply further customization.
 * <p>
 * After the request has been configured, the methods
 * <ul>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpRequest#send}</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpRequest#sendStream}</li>
 *   <li> ()}</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpRequest#sendForm}</li>
 * </ul>
 * can be called.
 * The <code>sendXXX</code> methods perform the actual request, they can be called multiple times to perform the same HTTP
 * request at different points in time.
 * <p>
 * The handler is called back with
 * <ul>
 *   <li>an {@link io.vertx.reactivex.ext.web.client.HttpResponse} instance when the HTTP response has been received</li>
 *   <li>a failure when the HTTP request failed (like a connection error) or when the HTTP response could
 *   not be obtained (like connection or unmarshalling errors)</li>
 * </ul>
 * <p>
 * Most of the time, this client will buffer the HTTP response fully unless a specific  is used
 * such as .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.HttpRequest original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpRequest that = (HttpRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<HttpRequest> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest) obj),
    HttpRequest::getDelegate
  );

  private final io.vertx.ext.web.client.HttpRequest<T> delegate;
  public final io.vertx.lang.rx.TypeArg<T> __typeArg_0;
  
  public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rx.TypeArg.unknown();  }

  public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate, io.vertx.lang.rx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.web.client.HttpRequest getDelegate() {
    return delegate;
  }

  /**
   * Configure the request to use a new method <code>value</code>.
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> method(HttpMethod value) { 
    delegate.method(value);
    return this;
  }

  /**
   * Configure the request to use a custom HTTP method
   * @param method 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> rawMethod(String method) { 
    delegate.rawMethod(method);
    return this;
  }

  /**
   * Configure the request to use a new port <code>value</code>.
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> port(int value) { 
    delegate.port(value);
    return this;
  }

  /**
   * Configure the request to decode the response with the <code>responseCodec</code>.
   * @param responseCodec the response codec
   * @return a reference to this, so the API can be used fluently
   */
  public <U> io.vertx.reactivex.ext.web.client.HttpRequest<U> as(io.vertx.reactivex.ext.web.codec.BodyCodec<U> responseCodec) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<U> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
    return ret;
  }

  /**
   * Configure the request to use a new host <code>value</code>.
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> host(String value) { 
    delegate.host(value);
    return this;
  }

  /**
   * Configure the request to use a virtual host <code>value</code>.
   * <p/>
   * Usually the header <i>host</i> (<i>:authority</i> pseudo header for HTTP/2) is set from the request host value
   * since this host value resolves to the server IP address.
   * <p/>
   * Sometimes you need to set a host header for an address that does not resolve to the server IP address.
   * The virtual host value overrides the value of the actual <i>host</i> header (<i>:authority</i> pseudo header
   * for HTTP/2).
   * <p/>
   * The virtual host is also be used for SNI.
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> virtualHost(String value) { 
    delegate.virtualHost(value);
    return this;
  }

  /**
   * Configure the request to use a new request URI <code>value</code>.
   * <p>
   * When the uri has query parameters, they are set in the {@link io.vertx.reactivex.ext.web.client.HttpRequest#queryParams} multimap, overwritting
   * any parameters previously set.
   * @param value 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> uri(String value) { 
    delegate.uri(value);
    return this;
  }

  /**
   * Configure the request to add multiple HTTP headers .
   * @param headers The HTTP headers
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> putHeaders(io.vertx.reactivex.core.MultiMap headers) { 
    delegate.putHeaders(headers.getDelegate());
    return this;
  }

  /**
   * Configure the request to set a new HTTP header.
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> putHeader(String name, String value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @return The HTTP headers
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance(delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * Configure the request to perform basic access authentication.
   * <p>
   * In basic HTTP authentication, a request contains a header field of the form 'Authorization: Basic &#60;credentials&#62;',
   * where credentials is the base64 encoding of id and password joined by a colon.
   * </p>
   * @param id the id
   * @param password the password
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> basicAuthentication(String id, String password) { 
    delegate.basicAuthentication(id, password);
    return this;
  }

  /**
   * Configure the request to perform basic access authentication.
   * <p>
   * In basic HTTP authentication, a request contains a header field of the form 'Authorization: Basic &#60;credentials&#62;',
   * where credentials is the base64 encoding of id and password joined by a colon.
   * </p>
   * @param id the id
   * @param password the password
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> basicAuthentication(io.vertx.reactivex.core.buffer.Buffer id, io.vertx.reactivex.core.buffer.Buffer password) { 
    delegate.basicAuthentication(id.getDelegate(), password.getDelegate());
    return this;
  }

  /**
   * Configure the request to perform bearer token authentication.
   * <p>
   * In OAuth 2.0, a request contains a header field of the form 'Authorization: Bearer &#60;bearerToken&#62;',
   * where bearerToken is the bearer token issued by an authorization server to access protected resources.
   * </p>
   * @param bearerToken the bearer token
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> bearerTokenAuthentication(String bearerToken) { 
    delegate.bearerTokenAuthentication(bearerToken);
    return this;
  }

  public io.vertx.reactivex.ext.web.client.HttpRequest<T> ssl(Boolean value) { 
    delegate.ssl(value);
    return this;
  }

  /**
   * Configures the amount of time in milliseconds after which if the request does not return any data within the timeout
   * period an {@link java.util.concurrent.TimeoutException} fails the request.
   * <p>
   * Setting zero or a negative <code>value</code> disables the timeout.
   * @param value The quantity of time in milliseconds.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> timeout(long value) { 
    delegate.timeout(value);
    return this;
  }

  /**
   * Add a query parameter to the request.
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> addQueryParam(String paramName, String paramValue) { 
    delegate.addQueryParam(paramName, paramValue);
    return this;
  }

  /**
   * Set a query parameter to the request.
   * @param paramName the param name
   * @param paramValue the param value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> setQueryParam(String paramName, String paramValue) { 
    delegate.setQueryParam(paramName, paramValue);
    return this;
  }

  /**
   * Set wether or not to follow the directs for the request.
   * @param value true if redirections should be followed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> followRedirects(boolean value) { 
    delegate.followRedirects(value);
    return this;
  }

  /**
   * Add an expectation that the response is valid according to the provided <code>predicate</code>.
   * <p>
   * Multiple predicates can be added.
   * @param predicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> expect(Function<io.vertx.reactivex.ext.web.client.HttpResponse<Void>, io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult> predicate) { 
    delegate.expect(new java.util.function.Function<io.vertx.ext.web.client.HttpResponse<java.lang.Void>,io.vertx.ext.web.client.predicate.ResponsePredicateResult>() {
      public io.vertx.ext.web.client.predicate.ResponsePredicateResult apply(io.vertx.ext.web.client.HttpResponse<java.lang.Void> arg) {
        io.vertx.reactivex.ext.web.client.predicate.ResponsePredicateResult ret = predicate.apply(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(arg, io.vertx.lang.rx.TypeArg.unknown()));
        return ret.getDelegate();
      }
    });
    return this;
  }

  /**
   * Add an expectation that the response is valid according to the provided <code>predicate</code>.
   * <p>
   * Multiple predicates can be added.
   * @param predicate the predicate
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> expect(io.vertx.reactivex.ext.web.client.predicate.ResponsePredicate predicate) { 
    delegate.expect(predicate.getDelegate());
    return this;
  }

  /**
   * Return the current query parameters.
   * @return the current query parameters
   */
  public io.vertx.reactivex.core.MultiMap queryParams() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance(delegate.queryParams());
    return ret;
  }

  /**
   * Copy this request
   * @return a copy of this request
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> copy() { 
    io.vertx.reactivex.ext.web.client.HttpRequest<T> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.copy(), __typeArg_0);
    return ret;
  }

  /**
   * Allow or disallow multipart mixed encoding when sending  having files sharing the same
   * file name.
   * <br/>
   * The default value is <code>true</code>.
   * <br/>
   * Set to <code>false</code> if you want to achieve the behavior for <a href="http://www.w3.org/TR/html5/forms.html#multipart-form-data">HTML5</a>.
   * @param allow <code>true</code> allows use of multipart mixed encoding
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> multipartMixed(boolean allow) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<T> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance(delegate.multipartMixed(allow), __typeArg_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @param handler 
   */
  public void sendStream(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendStream(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendStream(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendStream(body, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @param handler 
   */
  public void sendStream(Flowable<io.vertx.reactivex.core.buffer.Buffer> body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendStream(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(body,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendStream(Flowable<io.vertx.reactivex.core.buffer.Buffer> body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendStream(body, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @param handler 
   */
  public void sendStream(Observable<io.vertx.reactivex.core.buffer.Buffer> body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendStream(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(body,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> stream.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendStream(Observable<io.vertx.reactivex.core.buffer.Buffer> body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendStream(body, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> buffer.
   * @param body the body
   * @param handler 
   */
  public void sendBuffer(io.vertx.reactivex.core.buffer.Buffer body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendBuffer(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> buffer.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendBuffer(io.vertx.reactivex.core.buffer.Buffer body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendBuffer(body, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @param handler 
   */
  public void sendJsonObject(JsonObject body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendJsonObject(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendJsonObject(JsonObject body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendJsonObject(body, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @param handler 
   */
  public void sendJson(Object body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendJson(body, new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> object encoded as json and the content type
   * set to <code>application/json</code>.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendJson(Object body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendJson(body, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   * @param body the body
   * @param handler 
   */
  public void sendForm(io.vertx.reactivex.core.MultiMap body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendForm(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>application/x-www-form-urlencoded</code>.
   * <p>
   * When the content type header is previously set to <code>multipart/form-data</code> it will be used instead.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendForm(io.vertx.reactivex.core.MultiMap body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendForm(body, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>multipart/form-data</code>. You may use this method to send attributes and upload files.
   * @param body the body
   * @param handler 
   */
  public void sendMultipartForm(io.vertx.reactivex.ext.web.multipart.MultipartForm body, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.sendMultipartForm(body.getDelegate(), new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.HttpRequest#send} but with an HTTP request <code>body</code> multimap encoded as form and the content type
   * set to <code>multipart/form-data</code>. You may use this method to send attributes and upload files.
   * @param body the body
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSendMultipartForm(io.vertx.reactivex.ext.web.multipart.MultipartForm body) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sendMultipartForm(body, handler);
    });
  }

  /**
   * Send a request, the <code>handler</code> will receive the response as an {@link io.vertx.reactivex.ext.web.client.HttpResponse}.
   * @param handler 
   */
  public void send(Handler<AsyncResult<io.vertx.reactivex.ext.web.client.HttpResponse<T>>> handler) { 
    delegate.send(new Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<T>>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.HttpResponse<T>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.HttpResponse.newInstance(ar.result(), __typeArg_0)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Send a request, the <code>handler</code> will receive the response as an {@link io.vertx.reactivex.ext.web.client.HttpResponse}.
   * @return 
   */
  public Single<io.vertx.reactivex.ext.web.client.HttpResponse<T>> rxSend() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      send(handler);
    });
  }

  /**
   * Configure the request to set a new HTTP header with multiple values.
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<T> putHeader(String name, Iterable<String> value) { 
    delegate.putHeader(name, value);
    return this;
  }

  private io.vertx.reactivex.core.MultiMap cached_0;

  public static <T>HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
    return arg != null ? new HttpRequest<T>(arg) : null;
  }

  public static <T>HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, io.vertx.lang.rx.TypeArg<T> __typeArg_T) {
    return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
  }
}
