/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 * A pretty error handler for rendering error pages. When working in development mode
 * exception details will be returned in the server responses, otherwise or when
 * manually specified no exception details are returned in the HTTP response.
 *
 * The reason the display of the exception details is by default dependent of the mode
 * is to follow the security best practices:
 * <a href="https://www.owasp.org/index.php/Improper_Error_Handling">https://www.owasp.org/index.php/Improper_Error_Handling</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ErrorHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.ErrorHandler.class)
public class ErrorHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ErrorHandler that = (ErrorHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ErrorHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ErrorHandler((io.vertx.ext.web.handler.ErrorHandler) obj),
    ErrorHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ErrorHandler delegate;
  
  public ErrorHandler(io.vertx.ext.web.handler.ErrorHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.ErrorHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create an error handler using defaults
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create() { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance(io.vertx.ext.web.handler.ErrorHandler.create());
    return ret;
  }

  /**
   * Create an error handler
   * @param errorTemplateName the error template name - will be looked up from the classpath
   * @param displayExceptionDetails true if exception details should be displayed
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create(String errorTemplateName, boolean displayExceptionDetails) { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance(io.vertx.ext.web.handler.ErrorHandler.create(errorTemplateName, displayExceptionDetails));
    return ret;
  }

  /**
   * Create an error handler
   * @param displayExceptionDetails true if exception details should be displayed
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create(boolean displayExceptionDetails) { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance(io.vertx.ext.web.handler.ErrorHandler.create(displayExceptionDetails));
    return ret;
  }

  /**
   * Create an error handler
   * @param errorTemplateName the error template name - will be looked up from the classpath
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create(String errorTemplateName) { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance(io.vertx.ext.web.handler.ErrorHandler.create(errorTemplateName));
    return ret;
  }

  /**
   * The default template to use for rendering
   */
  public static final String DEFAULT_ERROR_HANDLER_TEMPLATE = io.vertx.ext.web.handler.ErrorHandler.DEFAULT_ERROR_HANDLER_TEMPLATE;

  public static  ErrorHandler newInstance(io.vertx.ext.web.handler.ErrorHandler arg) {
    return arg != null ? new ErrorHandler(arg) : null;
  }
}
