/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;
import io.vertx.ext.web.handler.LoggerFormat;

/**
 * A handler which logs request information to the Vert.x logger.
 * You should mount this handler before any handler that could fail the routing context
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.LoggerHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.LoggerHandler.class)
public class LoggerHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LoggerHandler that = (LoggerHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<LoggerHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new LoggerHandler((io.vertx.ext.web.handler.LoggerHandler) obj),
    LoggerHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.LoggerHandler delegate;
  
  public LoggerHandler(io.vertx.ext.web.handler.LoggerHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.LoggerHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler with default format
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.LoggerHandler create() { 
    io.vertx.reactivex.ext.web.handler.LoggerHandler ret = io.vertx.reactivex.ext.web.handler.LoggerHandler.newInstance(io.vertx.ext.web.handler.LoggerHandler.create());
    return ret;
  }

  /**
   * Create a handler with he specified format
   * @param format the format
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.LoggerHandler create(LoggerFormat format) { 
    io.vertx.reactivex.ext.web.handler.LoggerHandler ret = io.vertx.reactivex.ext.web.handler.LoggerHandler.newInstance(io.vertx.ext.web.handler.LoggerHandler.create(format));
    return ret;
  }

  /**
   * Create a handler with he specified format
   * @param immediate true if logging should occur as soon as request arrives
   * @param format the format
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.LoggerHandler create(boolean immediate, LoggerFormat format) { 
    io.vertx.reactivex.ext.web.handler.LoggerHandler ret = io.vertx.reactivex.ext.web.handler.LoggerHandler.newInstance(io.vertx.ext.web.handler.LoggerHandler.create(immediate, format));
    return ret;
  }

  public static final LoggerFormat DEFAULT_FORMAT = io.vertx.ext.web.handler.LoggerHandler.DEFAULT_FORMAT;

  public static  LoggerHandler newInstance(io.vertx.ext.web.handler.LoggerHandler arg) {
    return arg != null ? new LoggerHandler(arg) : null;
  }
}
