/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import org.dataloader.DataLoaderRegistry;
import graphql.GraphQL;
import io.vertx.core.Handler;
import java.util.function.Function;
import io.vertx.ext.web.handler.graphql.ApolloWSOptions;

/**
 * A handler for GraphQL requests sent over Apollo's <code>subscriptions-transport-ws</code> transport.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ApolloWSHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.graphql.ApolloWSHandler.class)
public class ApolloWSHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApolloWSHandler that = (ApolloWSHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<ApolloWSHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new ApolloWSHandler((io.vertx.ext.web.handler.graphql.ApolloWSHandler) obj),
    ApolloWSHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ApolloWSHandler delegate;
  
  public ApolloWSHandler(io.vertx.ext.web.handler.graphql.ApolloWSHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.graphql.ApolloWSHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Customize the connection .
   * This handler will be called at the beginning of each websocket connection.
   * @param connectionHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler connectionHandler(Handler<io.vertx.reactivex.core.http.ServerWebSocket> connectionHandler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        connectionHandler.handle(io.vertx.reactivex.core.http.ServerWebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Customize the message .
   * This handler will be called for each {@link io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage} received.
   * @param messageHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler messageHandler(Handler<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage> messageHandler) { 
    delegate.messageHandler(new Handler<io.vertx.ext.web.handler.graphql.ApolloWSMessage>() {
      public void handle(io.vertx.ext.web.handler.graphql.ApolloWSMessage event) {
        messageHandler.handle(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Customize the end .
   * This handler will be called at the end of each websocket connection.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler endHandler(Handler<io.vertx.reactivex.core.http.ServerWebSocket> endHandler) { 
    delegate.endHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        endHandler.handle(io.vertx.reactivex.core.http.ServerWebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Customize the query context object.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler queryContext(Function<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage, Object> factory) { 
    delegate.queryContext(new java.util.function.Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,java.lang.Object>() {
      public java.lang.Object apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        Object ret = factory.apply(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage.newInstance(arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the default {@link io.vertx.ext.web.handler.graphql.ApolloWSOptions}.
   * @param graphQL 
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler create(GraphQL graphQL) { 
    io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler ret = io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler.newInstance(io.vertx.ext.web.handler.graphql.ApolloWSHandler.create(graphQL));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param graphQL 
   * @param options options for configuring the {@link io.vertx.ext.web.handler.graphql.ApolloWSOptions}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler create(GraphQL graphQL, ApolloWSOptions options) { 
    io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler ret = io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler.newInstance(io.vertx.ext.web.handler.graphql.ApolloWSHandler.create(graphQL, options));
    return ret;
  }

  /**
   * Customize the .
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler dataLoaderRegistry(Function<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage, DataLoaderRegistry> factory) { 
    delegate.dataLoaderRegistry(new java.util.function.Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,org.dataloader.DataLoaderRegistry>() {
      public org.dataloader.DataLoaderRegistry apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        DataLoaderRegistry ret = factory.apply(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage.newInstance(arg));
        return ret;
      }
    });
    return this;
  }


  public static  ApolloWSHandler newInstance(io.vertx.ext.web.handler.graphql.ApolloWSHandler arg) {
    return arg != null ? new ApolloWSHandler(arg) : null;
  }
}
