/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.sockjs;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.BridgeOptions;

/**
 *
 * A handler that allows you to handle SockJS connections from clients.
 * <p>
 * We currently support version 0.3.3 of the SockJS protocol, which can be found in
 * <a href="https://github.com/sockjs/sockjs-protocol/tree/v0.3.3">this tag:</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.SockJSHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.ext.web.handler.sockjs.SockJSHandler.class)
public class SockJSHandler implements io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SockJSHandler that = (SockJSHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SockJSHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SockJSHandler((io.vertx.ext.web.handler.sockjs.SockJSHandler) obj),
    SockJSHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.SockJSHandler delegate;
  
  public SockJSHandler(io.vertx.ext.web.handler.sockjs.SockJSHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.web.handler.sockjs.SockJSHandler getDelegate() {
    return delegate;
  }

  /**
   * Create a SockJS handler
   * @param vertx the Vert.x instance
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler ret = io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler.newInstance(io.vertx.ext.web.handler.sockjs.SockJSHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a SockJS handler
   * @param vertx the Vert.x instance
   * @param options options to configure the handler
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler create(io.vertx.reactivex.core.Vertx vertx, SockJSHandlerOptions options) { 
    io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler ret = io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler.newInstance(io.vertx.ext.web.handler.sockjs.SockJSHandler.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Set a SockJS socket handler. This handler will be called with a SockJS socket whenever a SockJS connection
   * is made from a client
   * @param handler the handler
   * @return a router to be mounted on an existing router
   */
  public io.vertx.reactivex.ext.web.Router socketHandler(Handler<io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket> handler) { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance(delegate.socketHandler(new Handler<io.vertx.ext.web.handler.sockjs.SockJSSocket>() {
      public void handle(io.vertx.ext.web.handler.sockjs.SockJSSocket event) {
        handler.handle(io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Bridge the SockJS handler to the Vert.x event bus. This basically installs a built-in SockJS socket handler
   * which takes SockJS traffic and bridges it to the event bus, thus allowing you to extend the server-side
   * Vert.x event bus to browsers
   * @param bridgeOptions options to configure the bridge with
   * @return a router to be mounted on an existing router
   */
  public io.vertx.reactivex.ext.web.Router bridge(BridgeOptions bridgeOptions) { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance(delegate.bridge(bridgeOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSHandler#bridge} but specifying a handler
   * that will receive bridge events.
   * @param bridgeOptions options to configure the bridge with
   * @param bridgeEventHandler handler to receive bridge events
   * @return a router to be mounted on an existing router
   */
  public io.vertx.reactivex.ext.web.Router bridge(BridgeOptions bridgeOptions, Handler<io.vertx.reactivex.ext.web.handler.sockjs.BridgeEvent> bridgeEventHandler) { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance(delegate.bridge(bridgeOptions, new Handler<io.vertx.ext.web.handler.sockjs.BridgeEvent>() {
      public void handle(io.vertx.ext.web.handler.sockjs.BridgeEvent event) {
        bridgeEventHandler.handle(io.vertx.reactivex.ext.web.handler.sockjs.BridgeEvent.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * @param routingContext the rounting context
   */
  @Deprecated()
  public void handle(io.vertx.reactivex.ext.web.RoutingContext routingContext) { 
    delegate.handle(routingContext.getDelegate());
  }


  public static  SockJSHandler newInstance(io.vertx.ext.web.handler.sockjs.SockJSHandler arg) {
    return arg != null ? new SockJSHandler(arg) : null;
  }
}
