/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.micrometer;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.Handler;

/**
 * A Vert.x Web {@link io.vertx.reactivex.ext.web.Route} handler for Prometheus metrics scraping.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.micrometer.PrometheusScrapingHandler original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.micrometer.PrometheusScrapingHandler.class)
public class PrometheusScrapingHandler {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PrometheusScrapingHandler that = (PrometheusScrapingHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<PrometheusScrapingHandler> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new PrometheusScrapingHandler((io.vertx.micrometer.PrometheusScrapingHandler) obj),
    PrometheusScrapingHandler::getDelegate
  );

  private final io.vertx.micrometer.PrometheusScrapingHandler delegate;
  
  public PrometheusScrapingHandler(io.vertx.micrometer.PrometheusScrapingHandler delegate) {
    this.delegate = delegate;
  }

  public io.vertx.micrometer.PrometheusScrapingHandler getDelegate() {
    return delegate;
  }

  /**
   * Creates a Vert.x Web {@link io.vertx.reactivex.ext.web.Route} handler for Prometheus metrics scraping.
   * The default backend registry is used.
   * @return a {@link io.vertx.reactivex.ext.web.Route} handler for the default backend registry
   */
  public static Handler<io.vertx.reactivex.ext.web.RoutingContext> create() { 
    Handler<io.vertx.reactivex.ext.web.RoutingContext> ret = new Handler<io.vertx.reactivex.ext.web.RoutingContext>() {
      public void handle(io.vertx.reactivex.ext.web.RoutingContext event) {
          io.vertx.micrometer.PrometheusScrapingHandler.create().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Creates a Vert.x Web {@link io.vertx.reactivex.ext.web.Route} handler for Prometheus metrics scraping.
   * The registry specified by <code>registryName</code> is used.
   * @param registryName the backend metrics registry
   * @return a {@link io.vertx.reactivex.ext.web.Route} handler for a specific metrics registry
   */
  public static Handler<io.vertx.reactivex.ext.web.RoutingContext> create(String registryName) { 
    Handler<io.vertx.reactivex.ext.web.RoutingContext> ret = new Handler<io.vertx.reactivex.ext.web.RoutingContext>() {
      public void handle(io.vertx.reactivex.ext.web.RoutingContext event) {
          io.vertx.micrometer.PrometheusScrapingHandler.create(registryName).handle(event.getDelegate());
      }
    };
    return ret;
  }


  public static  PrometheusScrapingHandler newInstance(io.vertx.micrometer.PrometheusScrapingHandler arg) {
    return arg != null ? new PrometheusScrapingHandler(arg) : null;
  }
}
