/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mysqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLSetOption;

/**
 * A connection to MySQL server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mysqlclient.MySQLConnection.class)
public class MySQLConnection extends io.vertx.reactivex.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLConnection that = (MySQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MySQLConnection> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MySQLConnection((io.vertx.mysqlclient.MySQLConnection) obj),
    MySQLConnection::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLConnection delegate;
  
  public MySQLConnection(io.vertx.mysqlclient.MySQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.mysqlclient.MySQLConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, MySQLConnectOptions connectOptions, Handler<AsyncResult<io.vertx.reactivex.mysqlclient.MySQLConnection>> handler) { 
    io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectOptions, new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>() {
      public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.mysqlclient.MySQLConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static Single<io.vertx.reactivex.mysqlclient.MySQLConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, MySQLConnectOptions connectOptions) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(vertx, connectOptions, handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.reactivex.core.Vertx vertx, String connectionUri, Handler<AsyncResult<io.vertx.reactivex.mysqlclient.MySQLConnection>> handler) { 
    io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectionUri, new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>() {
      public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.mysqlclient.MySQLConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static Single<io.vertx.reactivex.mysqlclient.MySQLConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, String connectionUri) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(vertx, connectionUri, handler);
    });
  }

  public io.vertx.reactivex.mysqlclient.MySQLConnection prepare(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.PreparedQuery>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.PreparedQuery.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.PreparedQuery> rxPrepare(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      prepare(sql, handler);
    });
  }

  public io.vertx.reactivex.mysqlclient.MySQLConnection exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.mysqlclient.MySQLConnection closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.reactivex.mysqlclient.MySQLConnection preparedQuery(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, handler);
    });
  }

  public io.vertx.reactivex.mysqlclient.MySQLConnection query(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.query(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      query(sql, handler);
    });
  }

  public io.vertx.reactivex.mysqlclient.MySQLConnection preparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, arguments.getDelegate(), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, arguments, handler);
    });
  }

  /**
   * Send a PING command to check if the server is alive.
   * @param handler the handler notified when the server responses to client
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mysqlclient.MySQLConnection ping(Handler<AsyncResult<Void>> handler) { 
    delegate.ping(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxPing() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      ping(handler);
    });
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mysqlclient.MySQLConnection specifySchema(String schemaName, Handler<AsyncResult<Void>> handler) { 
    delegate.specifySchema(schemaName, handler);
    return this;
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxSpecifySchema(String schemaName) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      specifySchema(schemaName, handler);
    });
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mysqlclient.MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> handler) { 
    delegate.getInternalStatistics(handler);
    return this;
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<String> rxGetInternalStatistics() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getInternalStatistics(handler);
    });
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mysqlclient.MySQLConnection setOption(MySQLSetOption option, Handler<AsyncResult<Void>> handler) { 
    delegate.setOption(option, handler);
    return this;
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxSetOption(MySQLSetOption option) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      setOption(option, handler);
    });
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mysqlclient.MySQLConnection resetConnection(Handler<AsyncResult<Void>> handler) { 
    delegate.resetConnection(handler);
    return this;
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxResetConnection() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      resetConnection(handler);
    });
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mysqlclient.MySQLConnection debug(Handler<AsyncResult<Void>> handler) { 
    delegate.debug(handler);
    return this;
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxDebug() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      debug(handler);
    });
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.mysqlclient.MySQLConnection changeUser(MySQLAuthOptions options, Handler<AsyncResult<Void>> handler) { 
    delegate.changeUser(options, handler);
    return this;
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @return a reference to this, so the API can be used fluently
   */
  public Completable rxChangeUser(MySQLAuthOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      changeUser(options, handler);
    });
  }


  public static  MySQLConnection newInstance(io.vertx.mysqlclient.MySQLConnection arg) {
    return arg != null ? new MySQLConnection(arg) : null;
  }
}
