/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mysqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.sqlclient.PoolOptions;

/**
 * A pool of MySQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLPool original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.mysqlclient.MySQLPool.class)
public class MySQLPool extends io.vertx.reactivex.sqlclient.Pool {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLPool that = (MySQLPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<MySQLPool> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new MySQLPool((io.vertx.mysqlclient.MySQLPool) obj),
    MySQLPool::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLPool delegate;
  
  public MySQLPool(io.vertx.mysqlclient.MySQLPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.mysqlclient.MySQLPool getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with a default <code>poolOptions</code>.
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(String connectionUri) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance(io.vertx.mysqlclient.MySQLPool.pool(connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(String connectionUri, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance(io.vertx.mysqlclient.MySQLPool.pool(connectionUri, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with a default <code>poolOptions</code>..
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(io.vertx.reactivex.core.Vertx vertx, String connectionUri) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance(io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(io.vertx.reactivex.core.Vertx vertx, String connectionUri, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance(io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  /**
   * Create a connection pool to the MySQL server configured with the given <code>connectOptions</code> and <code>poolOptions</code>.
   * @param connectOptions the options for the connection
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(MySQLConnectOptions connectOptions, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance(io.vertx.mysqlclient.MySQLPool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.mysqlclient.MySQLPool#pool} with a specific  instance.
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.reactivex.mysqlclient.MySQLPool pool(io.vertx.reactivex.core.Vertx vertx, MySQLConnectOptions connectOptions, PoolOptions poolOptions) { 
    io.vertx.reactivex.mysqlclient.MySQLPool ret = io.vertx.reactivex.mysqlclient.MySQLPool.newInstance(io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  public io.vertx.reactivex.mysqlclient.MySQLPool preparedQuery(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, handler);
    });
  }

  public io.vertx.reactivex.mysqlclient.MySQLPool query(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.query(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      query(sql, handler);
    });
  }

  public io.vertx.reactivex.mysqlclient.MySQLPool preparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, arguments.getDelegate(), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, arguments, handler);
    });
  }

  public io.vertx.reactivex.mysqlclient.MySQLPool preparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedBatch(sql, batch, handler);
    });
  }


  public static  MySQLPool newInstance(io.vertx.mysqlclient.MySQLPool arg) {
    return arg != null ? new MySQLPool(arg) : null;
  }
}
