/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.sentinel;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Interface for sentinel commands
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.sentinel.RedisSentinel original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.redis.sentinel.RedisSentinel.class)
public class RedisSentinel {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisSentinel that = (RedisSentinel) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<RedisSentinel> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new RedisSentinel((io.vertx.redis.sentinel.RedisSentinel) obj),
    RedisSentinel::getDelegate
  );

  private final io.vertx.redis.sentinel.RedisSentinel delegate;
  
  public RedisSentinel(io.vertx.redis.sentinel.RedisSentinel delegate) {
    this.delegate = delegate;
  }

  public io.vertx.redis.sentinel.RedisSentinel getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.redis.sentinel.RedisSentinel create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.redis.sentinel.RedisSentinel ret = io.vertx.reactivex.redis.sentinel.RedisSentinel.newInstance(io.vertx.redis.sentinel.RedisSentinel.create(vertx.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.redis.sentinel.RedisSentinel create(io.vertx.reactivex.core.Vertx vertx, JsonObject config) { 
    io.vertx.reactivex.redis.sentinel.RedisSentinel ret = io.vertx.reactivex.redis.sentinel.RedisSentinel.newInstance(io.vertx.redis.sentinel.RedisSentinel.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Show a list of monitored masters and their state
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel masters(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.masters(handler);
    return this;
  }

  /**
   * Show a list of monitored masters and their state
   * @return 
   */
  public Single<JsonArray> rxMasters() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      masters(handler);
    });
  }

  /**
   * Show the state and info of the specified master
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel master(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.master(name, handler);
    return this;
  }

  /**
   * Show the state and info of the specified master
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxMaster(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      master(name, handler);
    });
  }

  /**
   * Show a list of slaves for this master, and their state
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel slaves(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.slaves(name, handler);
    return this;
  }

  /**
   * Show a list of slaves for this master, and their state
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxSlaves(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      slaves(name, handler);
    });
  }

  /**
   * Show a list of sentinel instances for this master, and their state
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel sentinels(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.sentinels(name, handler);
    return this;
  }

  /**
   * Show a list of sentinel instances for this master, and their state
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxSentinels(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      sentinels(name, handler);
    });
  }

  /**
   * Return the ip and port number of the master with that name.
   * If a failover is in progress or terminated successfully for this master
   * it returns the address and port of the promoted slave
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel getMasterAddrByName(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.getMasterAddrByName(name, handler);
    return this;
  }

  /**
   * Return the ip and port number of the master with that name.
   * If a failover is in progress or terminated successfully for this master
   * it returns the address and port of the promoted slave
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxGetMasterAddrByName(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getMasterAddrByName(name, handler);
    });
  }

  /**
   * Reset all the masters with matching name.
   * The pattern argument is a glob-style pattern.
   * The reset process clears any previous state in a master (including a failover in pro
   * @param pattern pattern String
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel reset(String pattern, Handler<AsyncResult<Void>> handler) { 
    delegate.reset(pattern, handler);
    return this;
  }

  /**
   * Reset all the masters with matching name.
   * The pattern argument is a glob-style pattern.
   * The reset process clears any previous state in a master (including a failover in pro
   * @param pattern pattern String
   * @return 
   */
  public Completable rxReset(String pattern) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      reset(pattern, handler);
    });
  }

  /**
   * Force a failover as if the master was not reachable, and without asking for agreement to other Sentinels
   * (however a new version of the configuration will be published so that the other Sentinels
   * will update their configurations)
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel failover(String name, Handler<AsyncResult<String>> handler) { 
    delegate.failover(name, handler);
    return this;
  }

  /**
   * Force a failover as if the master was not reachable, and without asking for agreement to other Sentinels
   * (however a new version of the configuration will be published so that the other Sentinels
   * will update their configurations)
   * @param name master name
   * @return 
   */
  public Single<String> rxFailover(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      failover(name, handler);
    });
  }

  /**
   * Check if the current Sentinel configuration is able to reach the quorum needed to failover a master,
   * and the majority needed to authorize the failover. This command should be used in monitoring systems
   * to check if a Sentinel deployment is ok.
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel ckquorum(String name, Handler<AsyncResult<String>> handler) { 
    delegate.ckquorum(name, handler);
    return this;
  }

  /**
   * Check if the current Sentinel configuration is able to reach the quorum needed to failover a master,
   * and the majority needed to authorize the failover. This command should be used in monitoring systems
   * to check if a Sentinel deployment is ok.
   * @param name master name
   * @return 
   */
  public Single<String> rxCkquorum(String name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      ckquorum(name, handler);
    });
  }

  /**
   * Force Sentinel to rewrite its configuration on disk, including the current Sentinel state.
   * Normally Sentinel rewrites the configuration every time something changes in its state
   * (in the context of the subset of the state which is persisted on disk across restart).
   * However sometimes it is possible that the configuration file is lost because of operation errors,
   * disk failures, package upgrade scripts or configuration managers. In those cases a way to to force Sentinel to
   * rewrite the configuration file is handy. This command works even if the previous configuration file
   * is completely missing.
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.reactivex.redis.sentinel.RedisSentinel flushConfig(Handler<AsyncResult<Void>> handler) { 
    delegate.flushConfig(handler);
    return this;
  }

  /**
   * Force Sentinel to rewrite its configuration on disk, including the current Sentinel state.
   * Normally Sentinel rewrites the configuration every time something changes in its state
   * (in the context of the subset of the state which is persisted on disk across restart).
   * However sometimes it is possible that the configuration file is lost because of operation errors,
   * disk failures, package upgrade scripts or configuration managers. In those cases a way to to force Sentinel to
   * rewrite the configuration file is handy. This command works even if the previous configuration file
   * is completely missing.
   * @return 
   */
  public Completable rxFlushConfig() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      flushConfig(handler);
    });
  }


  public static  RedisSentinel newInstance(io.vertx.redis.sentinel.RedisSentinel arg) {
    return arg != null ? new RedisSentinel(arg) : null;
  }
}
