/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery.types;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.JDBCDataSource original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.servicediscovery.types.JDBCDataSource.class)
public class JDBCDataSource {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCDataSource that = (JDBCDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<JDBCDataSource> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new JDBCDataSource((io.vertx.servicediscovery.types.JDBCDataSource) obj),
    JDBCDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.JDBCDataSource delegate;
  
  public JDBCDataSource(io.vertx.servicediscovery.types.JDBCDataSource delegate) {
    this.delegate = delegate;
  }

  public io.vertx.servicediscovery.types.JDBCDataSource getDelegate() {
    return delegate;
  }

  public static Record createRecord(String name, JsonObject location, JsonObject metadata) { 
    Record ret = io.vertx.servicediscovery.types.JDBCDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param resultHandler The result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getJDBCClient(discovery, filter, handler);
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @param resultHandler The result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<Record, Boolean> filter, Handler<AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<Record, Boolean> filter) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getJDBCClient(discovery, filter, handler);
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @param resultHandler the result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration, Handler<AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getJDBCClient(discovery, filter, consumerConfiguration, handler);
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @param resultHandler the result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration, Handler<AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<Record, Boolean> filter, JsonObject consumerConfiguration) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getJDBCClient(discovery, filter, consumerConfiguration, handler);
    });
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.JDBCDataSource.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.JDBCDataSource.TYPE;

  public static  JDBCDataSource newInstance(io.vertx.servicediscovery.types.JDBCDataSource arg) {
    return arg != null ? new JDBCDataSource(arg) : null;
  }
}
