/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A pool of SQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Pool original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.Pool.class)
public class Pool extends io.vertx.reactivex.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pool that = (Pool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<Pool> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new Pool((io.vertx.sqlclient.Pool) obj),
    Pool::getDelegate
  );

  private final io.vertx.sqlclient.Pool delegate;
  
  public Pool(io.vertx.sqlclient.Pool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.sqlclient.Pool getDelegate() {
    return delegate;
  }

  public io.vertx.reactivex.sqlclient.Pool preparedQuery(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, handler);
    });
  }

  public io.vertx.reactivex.sqlclient.Pool query(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.query(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      query(sql, handler);
    });
  }

  public io.vertx.reactivex.sqlclient.Pool preparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, arguments.getDelegate(), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, arguments, handler);
    });
  }

  public io.vertx.reactivex.sqlclient.Pool preparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedBatch(sql, batch, handler);
    });
  }

  /**
   * Get a connection from the pool.
   * @param handler the handler that will get the connection result
   */
  public void getConnection(Handler<AsyncResult<io.vertx.reactivex.sqlclient.SqlConnection>> handler) { 
    delegate.getConnection(new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.SqlConnection.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get a connection from the pool.
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.SqlConnection> rxGetConnection() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      getConnection(handler);
    });
  }

  /**
   * Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
   * to the pool when the transaction ends.
   * @param handler 
   */
  public void begin(Handler<AsyncResult<io.vertx.reactivex.sqlclient.Transaction>> handler) { 
    delegate.begin(new Handler<AsyncResult<io.vertx.sqlclient.Transaction>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.Transaction> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.Transaction.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
   * to the pool when the transaction ends.
   * @return the transaction
   */
  public Single<io.vertx.reactivex.sqlclient.Transaction> rxBegin() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      begin(handler);
    });
  }

  /**
   * Close the pool and release the associated resources.
   */
  public void close() { 
    delegate.close();
  }


  public static  Pool newInstance(io.vertx.sqlclient.Pool arg) {
    return arg != null ? new Pool(arg) : null;
  }
}
