/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Defines the client operations with a database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.sqlclient.SqlClient.class)
public class SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlClient that = (SqlClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<SqlClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new SqlClient((io.vertx.sqlclient.SqlClient) obj),
    SqlClient::getDelegate
  );

  private final io.vertx.sqlclient.SqlClient delegate;
  
  public SqlClient(io.vertx.sqlclient.SqlClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.sqlclient.SqlClient getDelegate() {
    return delegate;
  }

  /**
   * Execute a simple query.
   * @param sql the query SQL
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlClient query(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.query(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Execute a simple query.
   * @param sql the query SQL
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      query(sql, handler);
    });
  }

  /**
   * Prepare and execute a query.
   * @param sql the prepared query SQL
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlClient preparedQuery(String sql, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Prepare and execute a query.
   * @param sql the prepared query SQL
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, handler);
    });
  }

  /**
   * Prepare and execute a query.
   * @param sql the prepared query SQL
   * @param arguments the list of arguments
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlClient preparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedQuery(sql, arguments.getDelegate(), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Prepare and execute a query.
   * @param sql the prepared query SQL
   * @param arguments the list of arguments
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedQuery(String sql, io.vertx.reactivex.sqlclient.Tuple arguments) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedQuery(sql, arguments, handler);
    });
  }

  /**
   * Prepare and execute a createBatch.
   * @param sql the prepared query SQL
   * @param batch the batch of tuples
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.SqlClient preparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance(ar.result(), (io.vertx.lang.rx.TypeArg)io.vertx.reactivex.sqlclient.Row.__TYPE_ARG)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Prepare and execute a createBatch.
   * @param sql the prepared query SQL
   * @param batch the batch of tuples
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxPreparedBatch(String sql, List<io.vertx.reactivex.sqlclient.Tuple> batch) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      preparedBatch(sql, batch, handler);
    });
  }

  /**
   * Close the client and release the associated resources.
   */
  public void close() { 
    delegate.close();
  }


  public static  SqlClient newInstance(io.vertx.sqlclient.SqlClient arg) {
    return arg != null ? new SqlClient(arg) : null;
  }
}
