/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements ReadStream<io.vertx.reactivex.core.buffer.Buffer>,
WriteStream<io.vertx.reactivex.core.buffer.Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver(this.getDelegate(), conv);
        }
        return this.observer;
    }

    public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.end((Object)data.getDelegate());
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public NetSocket handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public NetSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public NetSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    public NetSocket write(String str, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(str, handler);
        return this;
    }

    public Completable rxWrite(String str) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(str, (Handler<AsyncResult<Void>>)handler));
    }

    public NetSocket write(String str) {
        this.delegate.write(str);
        return this;
    }

    public NetSocket write(String str, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(str, enc, handler);
        return this;
    }

    public Completable rxWrite(String str, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(str, enc, (Handler<AsyncResult<Void>>)handler));
    }

    public NetSocket write(String str, String enc) {
        this.delegate.write(str, enc);
        return this;
    }

    public NetSocket write(io.vertx.reactivex.core.buffer.Buffer message, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(message.getDelegate(), handler);
        return this;
    }

    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer message) {
        return AsyncResultCompletable.toCompletable(handler -> this.write(message, (Handler<AsyncResult<Void>>)handler));
    }

    public NetSocket sendFile(String filename) {
        this.delegate.sendFile(filename);
        return this;
    }

    public NetSocket sendFile(String filename, long offset) {
        this.delegate.sendFile(filename, offset);
        return this;
    }

    public NetSocket sendFile(String filename, long offset, long length) {
        this.delegate.sendFile(filename, offset, length);
        return this;
    }

    public NetSocket sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public Completable rxSendFile(String filename) {
        return AsyncResultCompletable.toCompletable(handler -> this.sendFile(filename, (Handler<AsyncResult<Void>>)handler));
    }

    public NetSocket sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    public Completable rxSendFile(String filename, long offset) {
        return AsyncResultCompletable.toCompletable(handler -> this.sendFile(filename, offset, (Handler<AsyncResult<Void>>)handler));
    }

    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return AsyncResultCompletable.toCompletable(handler -> this.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)handler));
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.end((Handler<AsyncResult<Void>>)handler));
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public NetSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket upgradeToSsl(Handler<Void> handler) {
        this.delegate.upgradeToSsl(handler);
        return this;
    }

    public NetSocket upgradeToSsl(String serverName, Handler<Void> handler) {
        this.delegate.upgradeToSsl(serverName, handler);
        return this;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

