/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * AMQP Client entry point.
 * Use this interface to create an instance of {@link io.vertx.reactivex.amqp.AmqpClient} and connect to a broker and server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.amqp.AmqpClient.class)
public class AmqpClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpClient that = (AmqpClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<AmqpClient> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new AmqpClient((io.vertx.amqp.AmqpClient) obj),
    AmqpClient::getDelegate
  );

  private final io.vertx.amqp.AmqpClient delegate;
  
  public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
    this.delegate = delegate;
  }

  public AmqpClient(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpClient)delegate;
  }

  public io.vertx.amqp.AmqpClient getDelegate() {
    return delegate;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.amqp.AmqpClient} using an internal Vert.x instance (with default configuration) and
   * the given AMQP client configuration. Note that the created Vert.x instance will be closed when the client is
   * closed.
   * @param options the AMQP client options, may be <code>null</code> falling back to the default configuration
   * @return the created instances.
   */
  public static io.vertx.reactivex.amqp.AmqpClient create(AmqpClientOptions options) { 
    io.vertx.reactivex.amqp.AmqpClient ret = io.vertx.reactivex.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.amqp.AmqpClient} with the given Vert.x instance and the given options.
   * @param vertx the vert.x instance, must not be <code>null</code>
   * @param options the AMQP options, may be @{code null} falling back to the default configuration
   * @return the AMQP client instance
   */
  public static io.vertx.reactivex.amqp.AmqpClient create(io.vertx.reactivex.core.Vertx vertx, AmqpClientOptions options) { 
    io.vertx.reactivex.amqp.AmqpClient ret = io.vertx.reactivex.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @param connectionHandler handler that will process the result, giving either the connection or failure cause. Must not be <code>null</code>.
   * @return 
   */
  public io.vertx.reactivex.amqp.AmqpClient connect(Handler<AsyncResult<io.vertx.reactivex.amqp.AmqpConnection>> connectionHandler) { 
    delegate.connect(new Handler<AsyncResult<io.vertx.amqp.AmqpConnection>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpConnection> ar) {
        if (ar.succeeded()) {
          connectionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)ar.result())));
        } else {
          connectionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @return 
   */
  public Single<io.vertx.reactivex.amqp.AmqpConnection> rxConnect() { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      connect(handler);
    });
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @param closeHandler the close handler notified when the operation completes. It can be <code>null</code>.
   */
  public void close(Handler<AsyncResult<Void>> closeHandler) { 
    delegate.close(closeHandler);
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @param completionHandler the handler called with the receiver. The receiver has been opened.
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createReceiver(String address, Handler<AsyncResult<io.vertx.reactivex.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the client.
   */
  public Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(String address) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createReceiver(address, handler);
    });
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @param completionHandler The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
   * @return the connection.
   */
  public io.vertx.reactivex.amqp.AmqpClient createReceiver(String address, AmqpReceiverOptions receiverOptions, Handler<AsyncResult<io.vertx.reactivex.amqp.AmqpReceiver>> completionHandler) { 
    delegate.createReceiver(address, receiverOptions, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createReceiver(address, receiverOptions, handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param completionHandler The handler called with the sender, once opened
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createSender(String address, Handler<AsyncResult<io.vertx.reactivex.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the client.
   */
  public Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(String address) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createSender(address, handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @param completionHandler The handler called with the sender, once opened
   * @return the client.
   */
  public io.vertx.reactivex.amqp.AmqpClient createSender(String address, AmqpSenderOptions options, Handler<AsyncResult<io.vertx.reactivex.amqp.AmqpSender>> completionHandler) { 
    delegate.createSender(address, options, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the client.
   */
  public Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      createSender(address, options, handler);
    });
  }

  public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
    return arg != null ? new AmqpClient(arg) : null;
  }

}
