/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * AMQP Sender interface used to send messages.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpSender original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.amqp.AmqpSender.class)
public class AmqpSender implements io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpSender that = (AmqpSender) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<AmqpSender> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new AmqpSender((io.vertx.amqp.AmqpSender) obj),
    AmqpSender::getDelegate
  );

  private final io.vertx.amqp.AmqpSender delegate;
  
  public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
    this.delegate = delegate;
  }

  public AmqpSender(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpSender)delegate;
  }

  public io.vertx.amqp.AmqpSender getDelegate() {
    return delegate;
  }

  private io.vertx.reactivex.WriteStreamObserver<io.vertx.reactivex.amqp.AmqpMessage> observer;
  private io.vertx.reactivex.WriteStreamSubscriber<io.vertx.reactivex.amqp.AmqpMessage> subscriber;

  public synchronized io.vertx.reactivex.WriteStreamObserver<io.vertx.reactivex.amqp.AmqpMessage> toObserver() {
    if (observer == null) {
      java.util.function.Function<io.vertx.reactivex.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::getDelegate;
      observer = io.vertx.reactivex.RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized io.vertx.reactivex.WriteStreamSubscriber<io.vertx.reactivex.amqp.AmqpMessage> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.reactivex.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::getDelegate;
      subscriber = io.vertx.reactivex.RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final io.vertx.lang.rx.TypeArg<io.vertx.reactivex.amqp.AmqpMessage> TYPE_ARG_0 = new io.vertx.lang.rx.TypeArg<io.vertx.reactivex.amqp.AmqpMessage>(o1 -> io.vertx.reactivex.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Completable rxEnd() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.reactivex.amqp.AmqpMessage data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.amqp.AmqpMessage data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxEnd(io.vertx.reactivex.amqp.AmqpMessage data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.amqp.AmqpSender#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See  for an example of this being used.
   * <p/>
   * The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpSender write(io.vertx.reactivex.amqp.AmqpMessage data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpSender write(io.vertx.reactivex.amqp.AmqpMessage data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Completable rxWrite(io.vertx.reactivex.amqp.AmqpMessage data) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  public io.vertx.reactivex.amqp.AmqpSender exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpSender setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * Sends an AMQP message. The destination the configured sender address or the address configured in the message.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.reactivex.amqp.AmqpSender send(io.vertx.reactivex.amqp.AmqpMessage message) { 
    delegate.send(message.getDelegate());
    return this;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @param acknowledgementHandler the acknowledgement handler, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.reactivex.amqp.AmqpSender sendWithAck(io.vertx.reactivex.amqp.AmqpMessage message, Handler<AsyncResult<Void>> acknowledgementHandler) { 
    delegate.sendWithAck(message.getDelegate(), acknowledgementHandler);
    return this;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public Completable rxSendWithAck(io.vertx.reactivex.amqp.AmqpMessage message) { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      sendWithAck(message, handler);
    });
  }

  /**
   * Closes the sender.
   * @param handler called when the sender has been closed, must not be <code>null</code>
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the sender.
   * @return 
   */
  public Completable rxClose() { 
    return io.vertx.reactivex.impl.AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * @return the configured address.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Gets the connection having created the sender. Cannot be <code>null</code>
   * @return the connection having created the sender.
   */
  public io.vertx.reactivex.amqp.AmqpConnection connection() { 
    io.vertx.reactivex.amqp.AmqpConnection ret = io.vertx.reactivex.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  public static AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
    return arg != null ? new AmqpSender(arg) : null;
  }

}
